/* traditional test file for the Wiport library
 *  written by Dan CORLAN modified by {Dan | Marius}+
 */

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <grx20.h>


#ifdef TEST_TIME
#include <sys/timeb.h>
#include <time.h>
#endif

#ifdef WIPORT_X11
#include "wiport2x.h"
#else
#include "wiport2.h"
#endif

#ifdef TEST_TIME
#include "wiptime.h"
#endif

#include "wipres.h"

#ifdef TEST_TIME
struct timeb tm;
#endif

char tb[64];
#ifdef TEST_TIME
time_t tt;
#endif

extern int wi_widget_background;
extern int wi_widget_lightborder;
extern int wi_widget_darkborder;

/* get an integer from the input channel */
int get_short( ) {
  int r;
  r = fgetc(stdin);
  r += fgetc(stdin) >> 8;
  return r;
}

int process( ) {
  int code;
  switch( code = fgetc(stdin ) ) {
   case 'I': wi_initiate(); break;
   case 'G': wi_new_gwin(640, 480, 256); break;
   case 'D': {
     short i1, i2, i3, i4;
     i1 = get_short(); i2=get_short(); i3=get_short(); i4=get_short();
     printf( "D%2d", wi_new_dwin( i1, i2, i3, i4 ));
     }
   break;
   case 'C': 
    {
      short d, c;
/*
      d = get_short(); c=get_short();
      wi_set_color( d, c);*/
    }
    break;
   case 'L':
    {
      short d, x1, y1, x2, y2;
      d=get_short(); x1=get_short(); y1=get_short(); x2=get_short(); y2=get_short();
      wi_line( d, x1, y1, x2, y2 );
    }
    break;
  }
}


main() {
  short dd, d2;
  unsigned short c;
  GrMouseEvent mev;

  
#  if 0
  /* those will find their way in another package */
  wipres();
  resread( "marius.res" );
  wi_widget_background  = ires( "widget:background");
  wi_widget_lightborder = ires( "widget:lightborder" );
  wi_widget_darkborder  = ires( "widget:darkborder" );
# endif

  wi_initiate();
  printf("after initiate\n");
  //  GrMouseEraseCursor();
  printf("before new_gwin\n");
  wi_new_gwin( 640, 480, 16 );
  printf( "%d\n", wi_widget_background );
  dd = wi_new_dwin( 12, 25, 500, 430);
  d2 = wi_new_dwin( 500, 25, 100, 430);
  /* setup the help subsystem */
  wi_set_color( d2, 2 );
  wi_def_help_dwin( d2 );

#ifdef PUZZLED
  /* functions not implemented in wiport2x.c, implementation is for level
   * 1 of the wiport specification in wiport2l.c --- I have disabled
   * the next call for the moment */
  /* define some printing colors */
  _def_gray(GRAYS_PAPER, 0, 900);
  _def_gray(GRAYS_PAPER, 1, 700);
#endif
   
  use_color_s_tech();
  printf("before clear dwin\n");
  wi_clear_dwin( dd, PLANE_DWIN);
  wi_clear_dwin( d2, PLANE_DWIN );

  printf("before set color\n");
  wi_set_color( dd, 1 );
  printf("before wi line\n");
  wi_line( dd, 10, 10, 110, 110);
  wi_line( dd, 10, 110, 110, 10);
  
  wi_line( d2, 10, 10, 80, 10);
  wi_line( d2, 10, 15, 80, 15);
  printf("after wi line\n");
  wi_set_color( dd, 1 );
  wi_rect( dd, 100, 10, 25, 25 );
  c = wi_interact();
  printf("after wi interact\n");

  {
    /* warning local definition of the buffer, do not call gwaccept! */
    char textpadbuffer[ 101 ] = "";
    char second[10] = "";
    ugrel tp_ugrel;

    tp_ugrel = wi_textbuffer( dd, 10, 200, 20, 3, 100, textpadbuffer, 'm');
    wi_set_help( tp_ugrel, "Write, write." );
    wi_textbuffer( dd, 200, 200, 5, 1, 9, second, 'n' );
  }

#ifdef TEST_TIME
  ftime(&tm);
  tt = tm.time;
#endif
#ifdef TEST_TIME
  fprintf(stderr, "Time=%10d\n", tt);
  fprintf(stderr, "Ascii: %s\n", ctime(&tt));
  strcpy(tb, ctime(&tt));
  wi_time_panel(dd, 150, 250, tb, YEAR2, SECOND, 'k', 'A', 'N');
#endif
  wi_set_help( wi_button(dd, 150, 350, 200, 20, "Apsai-m", 'j')
	      , "Do it!" );

  do {
#  if 1
    c = wi_interact();
    printf( "wi_interact returns: %d.\n", c );
#   else
    do {
      GrMouseGetEvent( M_KEYPRESS | M_POLL, &mev );
    } while ( (mev.flags & M_KEYPRESS)==0 );
    printf( "key:%d (0x%1x) -> %d kbstat:%1x\n", mev.key
	   , mev.key, key_to_sym(mev.key), mev.kbstat );
#   endif
#ifdef TEST_TIME
    wi_time_input(c);
#endif
  } while((c & 0x00ff) != 'j');

    exit_now:
#ifdef TEST_EPS
  wi_print_dwin("test.eps", dd);
  wi_print_gwin("testg.eps");
#endif
  wi_terminate();
  return c;
}

