/*    WIPort ALL [platforms] 2
 *
 *    Copyright (c) 1994--1998 Alexandru Dan Corlan
 * 
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU Library General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    In short, you can use and modify this program. You can
 *    distribute the program with or without your modifications if you want,
 *    but you must not require licence fees and must provide the
 *    full source code with the distribution. If you make an application program
 *    which just calls functions from this library you may distribute that
 *    application program without source code, but also as an linkable object file, 
 *    and must distribute also this library with source code.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU Library General Public License for more details.
 *
 *    You should have received a copy of the GNU Library General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _WIPALL2_H
#define _WIPALL2_H
/*--

  \subsection{Elementary WIPORT types}
  \PackagePurpose{  % be short
  Integer subtypes which model various integer, set and 
  fixed point WIPORT types.
  }
  \FunctionInterraction{
  % The order in which functions are expected to be called
  % The way to use the package in general
  }
  \Exceptions{
  }
  \GlobalEffects{
  % Global effects on exported or external variables
  }
  \Preconditions{
  % Conditions to be met when the package starts to be used
  }
  \Performance{
  % How it is, not why and what to do
  }

  \begin{code}
  --*/

#include "wipkeys.h"

/* gwin */

#define gwin short
#define MAX_N_OF_GWINS 16

/* dwin */

#define dwin short
#define MAX_N_OF_DWINS 256

/* grel, grelorder */

#define grel unsigned short
#define grelorder unsigned short
#define MAX_N_OF_GRELS 65535

/* greltype */

#define greltype short

#define POINTGREL 1
#define LINEGREL  2
#define TEXTGREL  3
#define BUTTONGREL 4
#define SWITCHGREL 5
#define ASWITCHGREL 6
#define TEXTPADGREL 7
#define BUFFERGREL 8
#define RECTGREL 9
#define ARCGREL 10
#define WEDGEGREL 11
#define CIRCLEGREL 12
#define DISCGREL 13
#define TRIANGLEGREL 14
#define BEZIERGREL 15
#define FILLEDBEZIERGREL 16
#define ELLIPSEGREL 17
#define FILLEDELIPSEGREL 18
#define BITMAPGREL 19
#define HBUTTONGREL 20

#define GROUP 30

/* ugrel */

#define ugrel long

#define make_ugrel(g, d, gr) ((((ugrel)(g))<<24) | ((d)<<16) | (gr))
#define gwin_of_ugrel(u)     (gwin)((u>>24) & 0x000f)
#define dwin_of_ugrel(u)     (dwin)((u>>16) & 0x00ff)
#define grel_of_ugrel(u)     (grel)( u & 0x0000ffff)

/* pixed */

#define pixed long
#define MAX_PIXED 4096

/* border style */

#define border_style short

#define PLAIN_BORDER   0
#define RAISED_BORDER  1
#define LOWERED_BORDER 2

/* inevent */

#define inevent long

/* wi_keycode */

#define wi_keycode short   /* wi_keycodes follow */

/* uwi_keycode */

#define uwi_keycode long
#define make_uwi_keycode(g, d, gr)    ((((uwi_keycode)(g))<<24) | ((d)<<16) | (gr))
#define gwin_of_uwi_keycode(u)        (gwin)((u>>24) & 0x000f)
#define dwin_of_uwi_keycode(u)        (dwin)((u>>16) & 0x00ff)
#define wi_keycode_of_uwi_keycode(u)     (wi_keycode)( u & 0x0000ffff)

/* colorcode */

#define colorcode unsigned short

/* shade */

#define shade short 

/* angle */

#define angle long

/* technology */

#define technology short 

#define COLOR_SCREEN 1
#define GRAYS_SCREEN 2
#define BW_SCREEN    3
#define COLOR_PAPER  4
#define GRAYS_PAPER  5
#define BW_PAPER     6
#define COLOR_SLIDE  7
#define GRAYS_SLIDE  8
#define BW_SLIDE     9
/* the next function is obsolete */
void def_screen_color(short col, short red, short green, short blue);

/* exceptions */

#define NO_MEMORY 1
#define INVALID_COLOR_CODE 2
#define INVALID_TECHNOLOGY 3


#define NO_MEMORY_FOR_GWIN 1
#define GWIN_X_SIZE_TOO_LARGE 2
#define GWIN_Y_SIZE_TOO_LARGE 3
#define NO_INITIALIZATION 4
#define NO_MEMORY_FOR_DWIN 5
#define TOO_MANY_DWINS 6
#define OVF_GPPERDWIN 7
#define NO_MEMORY_FOR_GP 8
#define NO_MEMORY_FOR_SWITEXT 9
#define NO_MEMORY_FOR_BUTTEXT 10
#define NO_MEMORY_FOR_ALTSWITEXT 11
#define NO_MEMORY_FOR_TEXT 12
#define NO_MEMORY_FOR_TEXTPAD 13

#define FONT_INITIALISATION_ERROR 20

#define rraise(x)
#define textpadcontents(textpad, pos) (char)((char *)(textpad -> ext))[pos] /* [DEF] */ 


/*--
  \end{code}


  \subsection{GWIN \& children}
  
  \PackagePurpose{  % be short
  The data structures that
  internally describes a graphic window.
  }
  \FunctionInterraction{
  }
  \Exceptions{
  }
  \GlobalEffects{
  }
  \Preconditions{
  }
  \Performance{
  }
  
  \begin{code}
  --*/




#define GPSIZE 1024      /* size of the grel page */
#define NOGPPERDWIN 1024 /* maximum number of grel pages in a dwin */
                         /* this normally ammounts to 16384 grels */

#define DWINSPERGWIN 255 /* maximum n. of dwins in a gwindow */

/* types of lines */

#define FULL   0xffff
#define DOTTED 0x5555
#define DASHED 0x7a7a

/* text justification types */

#define LEFTJ 0
#define RIGHTJ 1
#define DOTJ 2
#define CENTERJ 3

/* the grel data type */

struct _grel {    
  short gtype;   
  short gcolor;        /* colors are described in the pallete and
                        * this is only a pointer there */
  short gstyle;        /* it is the font for the text grel */
  short gsize;         /* width for line */
  short gcap;          /* justification / capstyle */
  short gkey;           /* for buttons, textpads,  switches */
  short *gswv;          /* for switches/textpad buffer --- the external one */
  short swvval;         /* this value is the internal represenation */
  short x0;
  short y0;
  short x1;
  short y1;            
  short extsize;       /* maximum usefull size of the extension */
  short extfill;       /* -1 if not used --- static size */
  void *ext;           /* dynamically allocated buffer */
/* More data here for the text pads */

};

typedef struct _grel *grelpage;

#define GRELSIZE sizeof(struct _grel)          /* assumed to be so */
#define NOGPERPAGE (GPSIZE / GRELSIZE)         /* normally 64, in an 1K page */

typedef struct _dwin {
  short x0, y0;                 /* upper left corner positioned in the GWIN */
  short xl, yl;                 /* dimensions in pixels */
  short cr_draw_x, cr_draw_y;   /* current drawing position */
  long cr_col;                  /* current color */
  short cr_style;               /* current 16-bit linestyle */
  short cr_width;               /* current line width */
  short cr_cap;                 /* current linecap */
  short gpfill;                 /* entries in the next table */
  short gppfill;                /* entries in the last page */
  short style;			/* style of the border for the window */
  short bgd_color;

  short spotshotkey;            /* 0 or a key value */
  short horshotkey;             /* 0 or a key value */
  short vershotkey;             /* 0 or a key value */
  short rectshotkey;            /* 0 or a key value */

  grelpage gp[NOGPPERDWIN];
  } DWIN;

/* the graphic image */

#define GWIN struct _gwin

#define GWICONNSIZE 32
#define GWINNSIZE   64

struct _gwin {
  /* fields common to all the implementations */
  long gwibackground;
  long gwiforeground;
  char gwiconn[GWICONNSIZE];
  char gwinn[GWINNSIZE];
  short dwinfill;
  struct _dwin *dw[DWINSPERGWIN];
  /* fields for the help subsystem */
  void * help_private;		/* store the help messsages */
  int help_dwin;
  int help_on;
#ifdef X_PROTOCOL
  /* fields for the X11 implementation 
   * X_PROTOCOL is a standard define of the X specification
   */
  Display *gwid;
  int gwiscreen;
  Window gwiw;
  GC gwigc;
  XSizeHints gwihint;
  Colormap colormap;
  short clipped_dwin;
#endif
};


/* more definitions used by application programmer: */

/* The following definitions are given to the |wiportinit| function */

#define MAXDEPTH_VCHOICE 0
#define MAXWIDTH_VCHOICE 1
#define MAXHEIGHT_VCHOICE 2
#define DEFAULT_VCHOICE 3

extern short maxgwinxsize;
extern short maxgwinysize;
extern short maxgwindepth;


/* dwin styles */

#define PLANE_DWIN 0
#define LOWERED_DWIN 1
#define RAISED_DWIN 2



/* definition of the key that will perform selections from the keyboard */

extern short font_x_size;
extern short font_y_size;


/*--
  \end{code}

  \section{GWIN registry}

  \PackagePurpose{  % be short
  Registration of all gwins in
  the system.
  }
  \FunctionInterraction{
  % The order in which functions are expected to be called
  % The way to use the package in general
  }
  \Exceptions{
  }
  \GlobalEffects{
  % Global effects on exported or external variables
  }
  \Preconditions{
  % Conditions to be met when the package starts to be used
  }
  \Performance{
  % How it is, not why and what to do
  }

  \begin{code}
  --*/

GWIN *wi_crt_gwin_ptr();

/*--
  \end{code}

  \section{Internals of gwin and dwin management}
  % The name of the package is expected to be prezent,
  % normally in the proper ``section'' specification above.

  \PackagePurpose{  % be short
  }
  \FunctionInterraction{
  % The order in which functions are expected to be called
  % The way to use the package in general
  }
  \Exceptions{
  }
  \GlobalEffects{
  % Global effects on exported or external variables
  }
  \Preconditions{
  % Conditions to be met when the package starts to be used
  }
  \Performance{
  % How it is, not why and what to do
  }

  \begin{code}
  --*/


struct grel_iterator { /* [TYPE] */ 
  DWIN * dw;   /* the dwin containing the grel over which we iterate */
  short current_page;
  short index_in_page;
};

typedef struct grel_iterator ITERATOR; /* [TYPE] */ 

short _add_grel_page(DWIN *dw);
DWIN *dwalloc(short x0, short y0, short xl, short yl);
ITERATOR * init_fwd_grel_iterator(GWIN * gw, short d, ITERATOR * this);
ITERATOR * init_bwd_grel_iterator(GWIN * gw, short d, ITERATOR * this);
ITERATOR * iterator_forward(ITERATOR * this);
ITERATOR * iterator_backward(ITERATOR * this);
int check_upper_bound_grel(ITERATOR * this);
int check_lower_bound_grel(ITERATOR * this);
struct _grel * access_grel(ITERATOR * this);
struct _grel * last_grel (DWIN * dw);
struct _grel * ndx_to_grel( DWIN * dw, int ndx );
void _gpclear(grelpage g);
short _inc_gpfill(DWIN *dw);
void _dwin_clear(DWIN *dw);
void DosClearArea(GWIN * gw, short x0, short y0,
		  short xl, short yl, short col);
void DosFillRectangle(GWIN * gw, short x0, short y0, short xl, short yl);
void cleardwin(GWIN * gw, short d, short style);
int defintbutton(DWIN *dw, short x0, short y0,
		 short xl, short yl, char *text, short key);
int defintswitch(DWIN *dw, short x0, short y0,
		 short xl, short yl, char *text, short *swv, short key);
int defintaswitch(DWIN *dw, short x0, short y0,
		  short xl, short yl, char *text, short *swv, short key);
int insert_grel_coord(struct _grel *g, short x, short y);
int defintpoint(DWIN *dw, short x0, short y0, short col);
int defintline(DWIN *dw, short x0, short y0, short x1, short y1,
	       short col, short width, short style, short cap);
int defintrect( DWIN * dw, short x0, short y0, short x1, short y1, short col );
int definttext(DWIN *dw, short x0, short y0, short col, char *text);
int definttextpad(DWIN *dw, short x0, short y0, short nc, short nl,
		  char * buffer, short size, short key);
char * _locate_help( GWIN * gw, short x, short y );

/*--
  \end{code}

  \subsection{Technologies}

  \PackagePurpose{  % be short
  Technology implementation. Only the storage of the technolohies
  is implemented in this package. 
  }
  \FunctionInterraction{
  % The order in which functions are expected to be called
  % The way to use the package in general
  Some of the functions are called by the primitives in the WIPORT2 package,
  but those that do not require seting any hardware parameters
  are primitives exported by the WIPALL package.

  The \verb|_allocate_color_codes| must be the first function
  called, which specifies the number of color codes. The rest
  of the functions are storing and retrieving functions.
  }
  \Exceptions{
  \exc{\verb|NO_MEMORY|} is raised when an allocator
  does not have enough memory. All the partial allocations
  done until the exception is met are undone.
  \exc{\verb|INVALID_COLOR_CODE|} is raised when a
  color code not in the correct range is provided as argument.
  }
  \GlobalEffects{
  % Global effects on exported or external variables
  }
  \Preconditions{
  % Conditions to be met when the package starts to be used
  }
  \Performance{
  % How it is, not why and what to do
  }

  \begin{code}
  --*/


/*--
  \end{code}

  \funparagraph{\_allocate\_color\_codes}

  \PurposeReturn{  % be short
  Allocate the memory to store technologies' mappings. Initialise
  the memory locations with default values for all colors.
  }
  \Exceptions{
  \exc{\verb|NO_MEMORY|}.
  }
  \GlobalEffects{
  None. 
  }
  \Preconditions{
  None, the first function to be called from this subpackage.
  }
  \Performance{
  }

  \begin{code}
  --*/

short _allocate_color_codes(short n);

/*--
  \end{code}

  \subsection{Keychord implementation}

  \PackagePurpose{
  Implements the definition and retrieving of sequences
  of keys associated to some of the key codes.
  }
  \FunctionInterraction{
  }
  \Exceptions{
  }
  \GlobalEffects{
  % Global effects on exported or external variables
  }
  \Preconditions{
  % Conditions to be met when the package starts to be used
  }
  \Performance{
  % How it is, not why and what to do
  }

  \begin{code}
  --*/



/*--
  \end{code}

  \subsection{Exporting graphics}

  \PackagePurpose{
  This subpackage implements the functions (WIPORT primitives)
  which produce PostScript images from dwins, areas and gwins.
  }
  \FunctionInterraction{
  % The order in which functions are expected to be called
  % The way to use the package in general
  }
  \Exceptions{
  }
  \GlobalEffects{
  % Global effects on exported or external variables
  }
  \Preconditions{
  % Conditions to be met when the package starts to be used
  }
  \Performance{
  % How it is, not why and what to do
  }

  \begin{code}
  --*/


/*--
\end{code}

\section{textpad suport} 
% The name of the package is expected to be prezent,
% normally in the proper ``section'' specification above.

\PackagePurpose{
This package contains the parts of the textpad package that are
not dependent upon the graphical representation and thus can be used
in common by all the implementations of the WIPORT specification}
\FunctionInterraction{ 
The function \functiontag{\_tp\_init} will initialize an already allocated
textpad extension.
Function \functiontag{\_tp\_contents} will set the contents of the textpad,
and \functiontag{\_tp\_process\_key} will modify the contents of the textpad
according to the key pressed by the user.
}
\Exceptions{
}
\GlobalEffects{}
\Preconditions{}
\Performance{}

\begin{code}
--*/

struct _tp_ext {
  char * contents;		/* contents of the textpad */
  char contents_size;		/* maximum length of the contents */
  char contents_fill;		/* actual length of the contents */
  short sol[50];		/* indices to the start of each screen line */
  short line_nb;		/* number of entries in the above vector */
  short crs;			/* position of the cursor or -1 */

  /* the next value(s) are simply cached in this structure */
  short cursor_line;		/* signal oh which line  */
};

int _tp_init( struct _tp_ext * this, char * initialcontents
			  , int dimension );
void _tp_free( struct _tp_ext * this );
void _tp_select( struct _tp_ext * this, short width );
void _tp_end_selection( struct _tp_ext * this );
int _tp_process_key( struct _tp_ext * this, long key, short width );
void _tp_contents( struct _tp_ext * this, char * newcontents, short width );
char * _tp_access_contents( struct _tp_ext * this );
int _tp_cursor_line( struct _tp_ext * this );
int _tp_cursor_row( struct _tp_ext * this );
extern __inline__ char * _tp_access_line( struct _tp_ext * this, short line) { 
  return this->contents+this->sol[line]; 
}
extern __inline__ short _tp_line_length( struct _tp_ext * this, short line ) {
  return this->sol[line+1] - this->sol[line];
}


/*--
\end{code}

\subsection{get\_selection} 
\PackagePurpose{Search in the grel list associated with a given
gwin the grel that is selected as the result of some user interaction.}
\FunctionInterraction{ 
Use  \functiontag{get\_position\_selection} to find the selection
that resulted due to mouse interaction and \functiontag{get\_key\_selection}
to find the grel selection due to keyboard interaction. }
\Exceptions{
}
\GlobalEffects{}
\Preconditions{
% Conditions to be met when the package starts to be used
}
\Performance{
% How it is, not why and what to do
}

\begin{code}
--*/

struct selection {
  DWIN *lasthitdwin;
  struct _grel * hitgrel;
  short lasthitdwin_ndx;
};

void get_position_selection(struct selection *  sel, GWIN * gw
			    , short x, short y);
void get_key_selection(struct selection * sel
			   , GWIN * gw, short key);

/*--
\end{code}

\section{key definition} 
% The name of the package is expected to be prezent,
% normally in the proper ``section'' specification above.

\PackagePurpose{}
\FunctionInterraction{ 
% The order in which functions are expected to be called
% The way to use the package in general
}
\Exceptions{
}
\GlobalEffects{
% Global effects on exported or external variables
}
\Preconditions{
% Conditions to be met when the package starts to be used
}
\Performance{
% How it is, not why and what to do
}

\begin{code}
--*/

#endif   /* _WIPALL2_H */
