--    Wiport2 Ada95 binding, body
--
--    Copyright (c) 1994--1998 Alexandru Dan Corlan, Marius Seritan
-- 
--    This program is free software; you can redistribute it and/or modify
--    it under the terms of the GNU Library General Public License as published by
--    the Free Software Foundation; either version 2 of the License, or
--    (at your option) any later version.
--
--    In short, you can use and modify this program. You can
--    distribute the program with or without your modifications if you want,
--    but you must not require licence fees and must provide the
--    full source code with the distribution. If you make an application program
--    which just calls functions from this library you may distribute that
--    application program without source code, but also as an linkable object file, 
--    and must distribute also this library with source code.
--
--    This program is distributed in the hope that it will be useful,
--    but WITHOUT ANY WARRANTY; without even the implied warranty of
--    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--    GNU Library General Public License for more details.
--
--    You should have received a copy of the GNU Library General Public License
--    along with this program; if not, write to the Free Software
--    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


package body Wiport is

  procedure Wi_Set_Application_Name(Name: char_array);
  pragma Import (C, Wi_Set_Application_Name, "wi_set_app_name");

  function Wi_New_Gwin(X_Size, Y_Size: Pixed; N_Colors: short)
    return Gwin;
  pragma Import(C, Wi_New_Gwin, "wi_new_gwin");

  procedure Wi_Set_Gwin_Name(Name: char_array);
  pragma Import(C, Wi_Set_Gwin_Name, "wi_set_gwin_name");

  procedure Wi_Set_Crt_Gwin(G: Gwin);
  pragma Import(C, Wi_Set_Crt_Gwin, "wi_set_crt_gwin");

  function Wi_New_Dwin(X0, Y0, XL, YL: Pixed) return Dwin;
  pragma Import(C, Wi_New_Dwin, "wi_new_dwin");

  procedure Wi_Clear_Dwin(D: Dwin; Style: Short);
  pragma Import(C, Wi_Clear_Dwin, "wi_clear_dwin");

  function Wi_Text(D: Dwin; X, Y: Pixed; Width: Pixed;
                   T: char_array) return Ugrel;
  pragma Import(C, Wi_Text, "wi_text");

  function Wi_Button(D: Dwin;
                     X0, Y0, XL, YL: Pixed;
                     T: char_array
		     )  return Ugrel;
  pragma Import(C, Wi_Button, "_wi_button");
  procedure Wi_Set_Button_Key(Key: short);
  pragma Import(C, Wi_Set_Button_Key, "_set_button_key");

  function Wi_Switch(D: Dwin;
                     X0, Y0, XL, YL: Pixed;
		     T: char_array;
		     Place: access Key_Code;
		     Key: Key_Code
		     ) return Ugrel;
  pragma Import(C, Wi_Switch, "wi_switch");
  

  function Wi_Alt_Switch(D: Dwin;
                     X0, Y0, XL, YL: Pixed;
		     T: char_array;
		     Place: access Key_Code;
		     Key: Key_Code
		     ) return Ugrel;
  pragma Import(C, Wi_Alt_Switch, "wi_alt_switch");
  
  function Wi_Textpad(D: Dwin;
                      X0, Y0: Pixed;
		      NC: Integer;
		      T: char_array;
		      Key: Key_Code
		      ) return Ugrel;
  pragma Import(C, Wi_Textpad, "wi_textpad");

---- ================================================================
----
----                  THE STUB FUNCTIONS FOLLOW
----
---- They are usually provided in order to permit 
---- exception processing
----
---- ================================================================

  procedure Set_Application_Name(Name: String) is
  begin
    Wi_Set_Application_Name(To_C(Name));
    --
    -- Possible exceptions to catch and rethrow here:
    --
    -- String_Too_Long
  end Set_Application_Name;

  function New_Gwin(X_Size, Y_Size: Pixed; N_Colors: short) return Gwin is
    Retval: Gwin;
  begin
    Retval := Wi_New_Gwin(X_Size, Y_Size, N_Colors);
    return Retval;
    --
    -- Possible exceptions to catch and rethrow here:
    --
    -- Not_Enough_Memory
    -- Resolution_Unavailable
    end New_Gwin;

  procedure Set_Gwin_Name(Name: String) is

  begin
    Wi_Set_Gwin_Name(To_C(Name));
      --
      -- Possible exceptions to catch and rethrow here:
      --
      -- Out_Of_Graphic_Bounds
      -- No_Such_Gwin
    end Set_Gwin_Name;

  procedure Set_Crt_Gwin(G: Gwin) is

  begin
    Wi_Set_Crt_Gwin(G);
      --
      -- Possible exceptions to catch and rethrow here:
      --
      -- No_Such_Gwin
  end Set_Crt_Gwin;

  function New_Dwin(X0, Y0, XL, YL: Pixed) return Dwin is
    
    RV: Dwin;

  begin
    RV := Wi_New_Dwin(X0, Y0, XL, YL);
    return RV;
    --
    -- Possible exceptions to catch and rethrow here:
    --
    -- No_More_Dwins
  end New_Dwin;

  procedure Clear_Dwin(D: Dwin) is

  begin
    Wi_Clear_Dwin(D, 0);
    --
    -- Possible exceptions to catch and rethrow here:
    --
    -- No_More_Dwins
  end Clear_Dwin;

  function Text(D: Dwin; X, Y: Pixed; Width: Pixed; T: String) return UGrel is

   RV: Ugrel;

  begin
    RV := Wi_Text(D, X, Y, Width, To_C(T));
    --
    -- Possible exceptions to catch and rethrow here:
    --
    -- No_Such_Dwin
    -- No_Such_Grel
    return RV;
  end Text;


  function Button(D: Dwin; X0, Y0, XL, YL: Pixed; T: String; Key: Key_Code) 
                  return Ugrel is

  RV: Ugrel;
  The_Key: short;

  begin
    The_Key := short(Character'Pos(Key));
    Put("Pos(Key) = ");
    Put(Integer'Image(Integer(The_Key)));
    Put_Line(" ");
    Wi_Set_Button_Key(The_Key);
    RV := Wi_Button(D, X0, Y0, XL, YL, To_C(T));
    return RV;
  end;

  function Switch(D: Dwin; X0, Y0, XL, YL: Pixed; T: String;
                Place: access Key_Code; Key: Key_Code) return UGrel is
  
  RV: Ugrel;
    
  begin
    RV := Wi_Switch(D, X0, Y0, XL, YL, To_C(T), Place, Key);
    return RV;
  end;
  
  function Alt_Switch(D: Dwin; X0, Y0, XL, YL: Pixed; T: String;
                    Place: access Key_Code; Key: Key_Code) return Ugrel is
  
  RV: Ugrel;
  
  begin
  RV := Wi_Alt_Switch(D, X0, Y0, XL, YL, To_C(T), Place, Key);
  return RV;
  end;

  function Textpad(D: Dwin; X0, Y0: Pixed; NC: Integer;
                   T: access String; Key: Key_Code
                   ) return UGrel is
    RV: Ugrel;
    
  begin
    RV := Wi_Textpad(D, X0, Y0, NC, To_C(T.All), Key);
    return RV;
  end;

end Wiport;
