--    Wiport2 Ada95 Binding, header
--
--    Copyright (c) 1994--1998 Alexandru Dan Corlan, Marius Seritan
-- 
--    This program is free software; you can redistribute it and/or modify
--    it under the terms of the GNU Library General Public License as published by
--    the Free Software Foundation; either version 2 of the License, or
--    (at your option) any later version.
--
--    In short, you can use and modify this program. You can
--    distribute the program with or without your modifications if you want,
--    but you must not require licence fees and must provide the
--    full source code with the distribution. If you make an application program
--    which just calls functions from this library you may distribute that
--    application program without source code, but also as an linkable object file, 
--    and must distribute also this library with source code.
--
--    This program is distributed in the hope that it will be useful,
--    but WITHOUT ANY WARRANTY; without even the implied warranty of
--    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--    GNU Library General Public License for more details.
--
--    You should have received a copy of the GNU Library General Public License
--    along with this program; if not, write to the Free Software
--    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

with Interfaces.C.Strings; 
use Interfaces.C.Strings;

with Interfaces.C;
use Interfaces.C;

with System;
use System;

with Text_IO; use Text_IO;


package Wiport is

Max_N_Of_Gwins: constant integer := 16;
type Gwin is range 0 .. Max_N_Of_Gwins - 1;

Max_N_Of_Dwins: constant integer := 256;
type Dwin is range 0 .. Max_N_Of_Dwins - 1;

Max_N_Of_Grels: constant integer := 65636;
type Grel is range 0..Max_N_Of_Grels - 1;
type Grel_Order is range 0 .. Max_N_Of_Grels - 1;

type Grel_Type is (
  Point, Line, Text, Button, Switch, Alt_Switch, Text_Pad, Buffer,
  Rectangle, Arc, Wedge, Circle, Disk, Triangle, 
  Bezier, Filled_Bezier, Ellipse,
  Filled_Ellipse, Bitmap, Hidden_Button, Group );
for Grel_Type use (
  Point => 1, Line => 2, Text => 3, Button => 4,
  Switch => 5, Alt_Switch => 6, Text_Pad => 7,
  Buffer => 8, Rectangle => 9, Arc => 10, Wedge => 11,
  Circle => 12, Disk => 13, Triangle => 14, Bezier => 15,
  Filled_Bezier => 16, Ellipse => 17, Filled_Ellipse => 18,
  Bitmap => 19, Hidden_Button => 20, Group => 30 );

type UGrel is private;

Max_Pixed: constant Integer := 4096;
subtype Pixed is Integer range -Max_Pixed .. Max_Pixed;

type In_Event is private;

subtype Key_Code is Character;

type UKey_Code is private;

type Color_Code is range 0..65636;

type Shade is delta 0.001 range 0.0 .. 1.0;

type Angle is delta 0.001 range -359.999 .. 360.000;

type Technology is (
  Color_Screen, Grays_Screen, BW_Screen,
  Color_Paper, Grays_Paper, BW_Paper,
  Color_Slide, Grays_Slide, BW_Slide );
for Technology use (
  Color_Screen => 1, Grays_Screen => 2, BW_Screen => 3,
  Color_Paper => 4, Grays_Paper => 5, BW_Paper => 6,
  Color_Slide => 7, Grays_Slide => 8, BW_Slide => 9 ); 

procedure Initiate;
pragma Import (C, Initiate, "wi_initiate");

procedure Set_Application_Name(Name: String);

function New_Gwin(X_Size, Y_Size: Pixed; N_Colors: short)
  return Gwin;

procedure Set_Gwin_Name(Name: String);
procedure Set_Crt_Gwin(G: Gwin);

function Get_Crt_Gwin return Gwin;
pragma Import(C, Get_Crt_Gwin, "wi_get_crt_gwin");  -- no possible exceptions

function New_Dwin(X0, Y0, XL, YL: Pixed) return Dwin;

procedure Clear_Dwin(D: Dwin);

procedure Redraw_Area(D: Dwin; X0, Y0, XL, YL: Pixed);
pragma Import(C, Redraw_Area, "wi_redraw_area");

function Plot(D: Dwin; X, Y: Pixed) return Ugrel;
pragma Import(C, Plot, "wi_plot");

function Line(D: Dwin; X0, Y0, X1, Y1: Pixed) return Ugrel;
pragma Import(C, Line, "wi_line");

function Text(D: Dwin; X, Y: Pixed; Width: Pixed; T: String) 
              return Ugrel;

function Button(D: Dwin; X0, Y0, XL, YL: Pixed; T: String; Key: Key_Code)
                return Ugrel;

function Switch(D: Dwin; X0, Y0, XL, YL: Pixed; T: String;
                Place: access Key_Code; Key: Key_Code)
                return Ugrel;

function Alt_Switch(D: Dwin; X0, Y0, XL, YL: Pixed; T: String;
                    Place: access Key_Code; Key: Key_Code)
                    return Ugrel;

function Textpad(D: Dwin;
                 X0, Y0: Pixed;
                 NC: Integer;      -- Must be equal to (T.all)'Size
                 T: access String; -- The size of the string is the buffer len.
                                   -- The useful contents are up to NUL.
                 Key: Key_Code
                 ) return Ugrel;

function Interact return Key_Code;
pragma Import(C, Interact, "wi_interact");

function Accept_Data return Key_Code;
pragma Import(C, Accept_Data, "wi_accept");

procedure Set_Color(D: Dwin; C: Color_Code);
pragma Import(C, Set_Color, "wi_set_color");

procedure Def_Color(C: Integer; R, G, B: Integer);
pragma Import(C, Def_Color, "def_screen_color");

procedure Free_Dwin(D: Dwin);
pragma Import(C, Free_Dwin, "free_dwin");

procedure Enter_Graphic_Block;
pragma Import(C, Enter_Graphic_Block, "enter_graphic_block");

procedure Exit_Graphic_Block;
pragma Import(C, Exit_Graphic_Block, "exit_graphic_block");

No_More_Memory:           exception;
Out_Of_Graphic_Bounds:    exception;
No_Such_Gwin:             exception;
No_More_Gwins:            exception;
No_Such_Dwin:             exception;
No_More_Dwins:            exception;
Key_Code_Already_Exists:  exception;
No_More_Grels:            exception;
No_Such_Group:            exception;
No_Such_Grel:             exception;
No_Such_Color_Code:       exception;
Grel_Has_No_Destination:  exception;
Grel_Has_No_Origin:       exception;
Grel_Has_No_Value:        exception;
Grel_Has_No_Text_Value:   exception;
Grel_Has_No_Label:        exception;
Shoot_Disabled:           exception;
Not_A_Screen_Technology:  exception;
Not_A_Paper_Technology:   exception;
Not_A_Color_Technology:   exception;
Not_A_BW_Technology:      exception;
Not_A_Grays_Technology:   exception;
Eps_Unit_Out_Of_Range:    exception;
Could_Not_Write_File:     exception;

private
  type Ugrel is new long;
  type In_Event is new long;
  type UKey_Code is new long;
      
end Wiport;

