/*    WIPORT 2 Main Header
 *
 *    Copyright (c) 1994--1998 Alexandru Dan Corlan, Marius Seritan
 * 
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU Library General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    In short, you can use and modify this program. You can
 *    distribute the program with or without your modifications if you want,
 *    but you must not require licence fees and must provide the
 *    full source code with the distribution. If you make an application program
 *    which just calls functions from this library you may distribute that
 *    application program without source code, but also as an linkable object file, 
 *    and must distribute also this library with source code.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU Library General Public License for more details.
 *
 *    You should have received a copy of the GNU Library General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Revision 1.2  1996/02/25  22:37:47  dcorlan
 * The wiport2l system, which now compiles from the box for MSDOS (I presume)
 * but anyway with svgalib-1.2.8  and grx-2.0, and with X11R6. Nevertheless,
 * this is the version shipped by mseritan and it does not work well.
 * Something is fishy with the keycodes and the mouse enters a dubious mode,
 * and it works veery slow and the current widget flickers on the screen.
 * It sometimes crashes when pressing a common button.
 *
 * wiport2x.c is actually obsolete.
 *
 * What I fear is that the files in the CVS repository are not the files
 * we actually use in the compilation.
 *
 * New things:
 *   wiport.fnt, wiport.fna are the new fonts.
 *   I don't know what should be the difference, if any, between Makefile
 *   and makefile.
 *
 * Revision 1.2  1994/12/31  18:37:38  root
 * Changed to make the first version of WIPTIME work.
 *
 */

#include "wipall2.h"


/*--
  \end{code}

  \section{Initialization}

  \PackagePurpose{
  A function that resets all the WIPORT2L data structures.
  }
  \FunctionInterraction{
  }
  \Exceptions{
  }
  \GlobalEffects{
  % Global effects on exported or external variables
  }
  \Preconditions{
  No other functions may be called before
  }
  \Performance{
  % How it is, not why and what to do
  }

  \funparagraph{wi\_initiate}
  \PurposeReturn{  % be short
  Resets all WIPORT2 data structures. Returns 1 if success, 0 if failure.
  }
  \Exceptions{
  }
  \GlobalEffects{
  }
  \Preconditions{
  Must be the first function called.
  }
  \Performance{
  }

  \begin{code}
  --*/

short wi_init();


/*--
  \end{code}

  \funparagraph{wi\_terminate}
  % The name of the function is expected to be prezent
  % in the sectioning element above

  \PurposeReturn{
  Disallocate all WIPORT2 data structures.
  }
  \Exceptions{
  }
  \GlobalEffects{
  % Global effects on exported or external variables
  }
  \Preconditions{
  % Conditions to be met when the function is called
  }
  \Performance{
  % How it is, not why and what to do about it
  }

  \begin{code}
  --*/

short wi_terminate();

/*--
  \end{code}

  \section{Graphic space}
  \PackagePurpose{
  Contains all the functions which set up a graphics space and provide
  labels and readjustments to it.
  }
  \FunctionInterraction{
  % The order in which functions are expected to be called
  % The way to use the package in general
  }
  \Exceptions{
  }
  \GlobalEffects{
  % Global effects on exported or external variables
  }
  \Preconditions{
  % Conditions to be met when the package starts to be used
  }
  \Performance{
  % How it is, not why and what to do
  }

  \funparagraph{wi\_new\_gwin}

  \PurposeReturn{
  Returns a newly created  {\tt gwin} which also becomes the current one.
  }
  \Exceptions{
  }
  \GlobalEffects{
  % Global effects on exported or external variables
  }
  \Preconditions{
  % Conditions to be met when the function is called
  }
  \Performance{
  % How it is, not why and what to do about it
  }

  \begin{code}
  --*/

gwin wi_new_gwin(pixed xsize, pixed ysize, short ncolors);


/*--
  \end{code}

  \funparagraph{wi\_set\_gwin\_name}
  % The name of the function is expected to be prezent
  % in the sectioning element above

  \PurposeReturn{  % be short
  1 if OK, 0 if error.
  }
  \Exceptions{
  }
  \GlobalEffects{
  % Global effects on exported or external variables
  }
  \Preconditions{
  % Conditions to be met when the function is called
  }
  \Performance{
  % How it is, not why and what to do about it
  }

  \begin{code}
  --*/

short wi_set_gwin_name(char *t);

short wi_get_x_res();


/*--
\end{code}

\funparagraph{wi\_color}
\PurposeReturn{  % be short
}
\Exceptions{
}
\GlobalEffects{
% Global effects on exported or external variables
}
\Preconditions{
% Conditions to be met when the function is called
}
\Performance{
% How it is, not why and what to do about it
}

\begin{code}
--*/
void wi_set_color( dwin d, colorcode c);
colorcode wi_get_color( dwin d );

/*--
  \end{code}

  \section{Dwin management}

  \PackagePurpose{  % be short
  Functions at the dwin level.
  }
  \FunctionInterraction{
  % The order in which functions are expected to be called
  % The way to use the package in general
  }
  \Exceptions{
  }
  \GlobalEffects{
  % Global effects on exported or external variables
  }
  \Preconditions{
  % Conditions to be met when the package starts to be used
  }
  \Performance{
  % How it is, not why and what to do
  }

  \funparagraph{wi\_new\_dwin}
  % The name of the function is expected to be prezent
  % in the sectioning element above

  \PurposeReturn{  % be short
  }
  \Exceptions{
  }
  \GlobalEffects{
  % Global effects on exported or external variables
  }
  \Preconditions{
  % Conditions to be met when the function is called
  }
  \Performance{
  % How it is, not why and what to do about it
  }

  \begin{code}
  --*/

dwin wi_new_dwin(pixed x0, pixed y0, pixed xl, pixed yl);


/*--
  \end{code}

  \funparagraph{wi\_clear\_dwin}
  % The name of the function is expected to be prezent
  % in the sectioning element above

  \PurposeReturn{  % be short
  }
  \Exceptions{
  }
  \GlobalEffects{
  % Global effects on exported or external variables
  }
  \Preconditions{
  % Conditions to be met when the function is called
  }
  \Performance{
  % How it is, not why and what to do about it
  }

  \begin{code}
  --*/

short wi_clear_dwin(dwin d, short style);


/*--
  \end{code}

  \funparagraph{wi\_redraw\_area}
  % The name of the function is expected to be prezent
  % in the sectioning element above

  \PurposeReturn{  % be short
  }
  \Exceptions{
  }
  \GlobalEffects{
  % Global effects on exported or external variables
  }
  \Preconditions{
  % Conditions to be met when the function is called
  }
  \Performance{
  % How it is, not why and what to do about it
  }

  \begin{code}
  --*/

short wi_redraw_area(dwin d, pixed x0, pixed y0, pixed xl, pixed yl);

/*--
  \end{code}

  \funparagraph{wi\_get\_char\_{x,y}\_size}
  % The name of the function is expected to be prezent
  % in the sectioning element above

  \PurposeReturn{  % be short
  }
  \Exceptions{
  }
  \GlobalEffects{
  % Global effects on exported or external variables
  }
  \Preconditions{
  % Conditions to be met when the function is called
  }
  \Performance{
  % How it is, not why and what to do about it
  }

  \begin{code}
  --*/

short wi_get_char_x_size();
short wi_get_char_y_size();
 


/*--
  \end{code}

  \section{Object description}

  \PackagePurpose{  % be short
  Define input and inout objects.
  }
  \FunctionInterraction{
  % The order in which functions are expected to be called
  % The way to use the package in general
  }
  \Exceptions{
  }
  \GlobalEffects{
  % Global effects on exported or external variables
  }
  \Preconditions{
  % Conditions to be met when the package starts to be used
  }
  \Performance{
  % How it is, not why and what to do
  }

  \funparagraph{wi\_plot}

  \PurposeReturn{  % be short
  }
  \Exceptions{
  }
  \GlobalEffects{
  % Global effects on exported or external variables
  }
  \Preconditions{
  % Conditions to be met when the function is called
  }
  \Performance{
  % How it is, not why and what to do about it
  }

  \begin{code}
  --*/

ugrel wi_plot(dwin d, pixed x, pixed y);


/*--
  \end{code}

  \funparagraph{wi\_line}
  % The name of the function is expected to be prezent
  % in the sectioning element above

  \PurposeReturn{  % be short
  }
  \Exceptions{
  }
  \GlobalEffects{
  % Global effects on exported or external variables
  }
  \Preconditions{
  % Conditions to be met when the function is called
  }
  \Performance{
  % How it is, not why and what to do about it
  }

  \begin{code}
  --*/

ugrel wi_line(dwin d, pixed x0, pixed y0, pixed xl, pixed yl);


/*--
\end{code}

\funparagraph{wi\_rect}
\PurposeReturn{  % be short
}
\Exceptions{
}
\GlobalEffects{
% Global effects on exported or external variables
}
\Preconditions{
% Conditions to be met when the function is called
}
\Performance{
% How it is, not why and what to do about it
}

\begin{code}
--*/
ugrel wi_rect( dwin d, pixed x0, pixed y0, pixed xl, pixed yl );

/*--
  \end{code}

  \funparagraph{wi\_button}
  % The name of the function is expected to be prezent
  % in the sectioning element above

  \PurposeReturn{  % be short
  }
  \Exceptions{
  }
  \GlobalEffects{
  % Global effects on exported or external variables
  }
  \Preconditions{
  % Conditions to be met when the function is called
  }
  \Performance{
  % How it is, not why and what to do about it
  }

  \begin{code}
  --*/

ugrel wi_button(dwin d, pixed x0, pixed y0, pixed xl, pixed yl,
		char *t, wi_keycode key);

/*--
  \end{code}

  \funparagraph{wi\_hbutton}
  % The name of the function is expected to be prezent
  % in the sectioning element above

  \PurposeReturn{  % be short
  }
  \Exceptions{
  }
  \GlobalEffects{
  % Global effects on exported or external variables
  }
  \Preconditions{
  % Conditions to be met when the function is called
  }
  \Performance{
  % How it is, not why and what to do about it
  }

  \begin{code}
  --*/

ugrel wi_hbutton(dwin d, wi_keycode key);


/*--
  \end{code}

  \funparagraph{wi\_switch}
  % The name of the function is expected to be prezent
  % in the sectioning element above

  \PurposeReturn{  % be short
  }
  \Exceptions{
  }
  \GlobalEffects{
  % Global effects on exported or external variables
  }
  \Preconditions{
  % Conditions to be met when the function is called
  }
  \Performance{
  % How it is, not why and what to do about it
  }

  \begin{code}
  --*/


ugrel wi_switch(dwin d, pixed x0, pixed y0, pixed xl, pixed yl,
		char *t, wi_keycode *swv, wi_keycode key);


/*--
  \end{code}

  \funparagraph{wi\_alt\_switch}
  % The name of the function is expected to be prezent
  % in the sectioning element above

  \PurposeReturn{  % be short
  }
  \Exceptions{
  }
  \GlobalEffects{
  % Global effects on exported or external variables
  }
  \Preconditions{
  % Conditions to be met when the function is called
  }
  \Performance{
  % How it is, not why and what to do about it
  }

  \begin{code}
  --*/


ugrel wi_alt_switch(dwin d, pixed x0, pixed y0, pixed xl, pixed yl,
		char *t, wi_keycode *swv, wi_keycode key);


/*--
\end{code}

\funparagraph{wi\_textpad}
\PurposeReturn{The ugrel created}
\Exceptions{}
\GlobalEffects{}
\Preconditions{}
\Performance{}

\begin{code}
--*/
ugrel wi_textpad(dwin d, pixed x, pixed y, pixed nc, pixed nl, short ssize,
		 char *text, wi_keycode key);

ugrel wi_textbuffer(dwin d, pixed x, pixed y, pixed nc, pixed nl, short ssize,
		 char *text, wi_keycode key);

/*--
  \end{code}

  \chapter{WIPORT-1 definitions}

  \PackagePurpose{  % be short
  This subpackage is an alternative means of calling the WIPORT-2 functions,
  which preserves compatibility with the previous (WIPORT-1) version.
  As all applications are converted to the new style, preserving it
  will no longer be necessary.
  }
  \FunctionInterraction{
  % The order in which functions are expected to be called
  % The way to use the package in general
  }
  \Exceptions{
  }
  \GlobalEffects{
  % Global effects on exported or external variables
  }
  \Preconditions{
  % Conditions to be met when the package starts to be used
  }
  \Performance{
  % How it is, not why and what to do
  }

  \begin{code}
  --*/


/* exception management */

extern short gwerrno;

/* variables returning shot results */

extern short xspotshot;
extern short yspotshot;
extern short xhorshot;
extern short y0horshot;
extern short y1horshot;
extern short x0vershot;
extern short x1vershot;
extern short yvershot;
extern short x0rectshot;
extern short x1rectshort;
extern short y0rectshot;
extern short y1rectshot;


/* Function definitions: The prototypes of the first version functions.
 * For compatibility with old applications, these will not yet be deleted.
 */

short wiportinit(void * display, int screen, short choice
                               , int argc, char ** argv);
void wiportclose(void);                                                                                                                  
GWIN * newgwin(short xl, short yl, char * gwtitle, char * gwictitle);
short newdwin(GWIN * gw, short x0, short y0, short xl, short yl);
int dwin_x_size(GWIN * gw, short d);
int dwin_y_size(GWIN * gw, short d);
void cleardwin(GWIN * gw, short d, short style);
int defbutton(GWIN * gw, short d, short x0, short y0, short xl, short yl,
              char * text, short key);
int defswitch(GWIN * gw, short d, short x0, short y0, short xl, short yl,
              char * text, short *swv, short key);
int defaltswitch(GWIN * gw, short d, short x0, short y0, short xl, short yl,
                char * text, short *swv, short key);
int deftextpad(GWIN * gw, short d, short x0, short y0, short nc, short nl,
               short size, char * buffer, short key);
void gsetcolor(GWIN *gw, short d, short col);
void gsetlinestyle(GWIN * gw, short d, short mask);
void gsetlinewidth(GWIN * gw, short d, short width);
void gsetlinecap(GWIN * gw, short d, short cap);
void gpoint(GWIN * gw, short d, short x, short y);
void gmoveto(GWIN * gw, short d, short x, short y);
void glineto(GWIN * gw, short d, short x, short y);
int gtext(GWIN * gw, short d, short x, short y, char * text);
void redwin(GWIN * gw, short d, short x0, short y0, short xl, short yl);
void setspotshot(GWIN * gw, short d, short key);
void sethorahot(GWIN * gw, short d, short key);
void setvershot(GWIN * gw, short d, short key);
void setrectshot(GWIN * gw, short d, short key);
short gwinteract(GWIN * gw); 
int gwpeep(void);
void gwaccept(GWIN * gw);

#define KEYBOARD_SELECTION 0x0d


/*--
\end{code}

\subsection{On line help} 
% The name of the package is expected to be prezent,
% normally in the proper ``section'' specification above.

\PackagePurpose{Associate a help string to any area on the screen.}
\FunctionInterraction{ 
Initialize the online help subsystem by specifing the help dwin
with function \functiontag{wi\_def\_help\_dwin}. Help can
be enabled or disabled for the current gwin by using the
functions \functiontag{wi\_set\_help\_on} and 
\functiontag{wi\_set\_help\_off}. A help string can be associated
with a given grel by using \functiontag{wi\_set\_grel\_help} and
can be deleted later by using \functiontag{wi\_del\_help}.
}
\Exceptions{
}
\GlobalEffects{
}
\Preconditions{The wiport library should be initialized.}
\Performance{}

\begin{code}
--*/

void wi_set_help( ugrel g, char * h );
long wi_set_area_help( dwin d, pixed x0, pixed y0, pixed xl, pixed yl );
void wi_del_help(  ugrel g );
void wi_def_help_dwin( ugrel d );
void wi_set_help_on( );
void wi_set_help_off( );

/*--
  \end{code}

  % MOVE THIS COMMENT TO THE END OF THE FILE
  \endoffile

  --*/


