/*    WIPORT2, lower no x
 *
 *    Copyright (c) 1994--1998 Marius Seritan, Alexandru Dan Corlan
 * 
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU Library General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    In short, you can use and modify this program. You can
 *    distribute the program with or without your modifications if you want,
 *    but you must not require licence fees and must provide the
 *    full source code with the distribution. If you make an application program
 *    which just calls functions from this library you may distribute that
 *    application program without source code, but also as an linkable object file, 
 *    and must distribute also this library with source code.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU Library General Public License for more details.
 *
 *    You should have received a copy of the GNU Library General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    This file is the LINUX implementation of the WIPORT
 *    specification using SVGA and GRX library
 *    Much of the code was taken from the MSC implementation
 *    written by Marius Seritan and from the X implementation
 *    written by A.D. Corlan; R. Corlan contributed lots of
 *    criticism, on the whole pH area (except for a limited range
 *    between pH=2 and pH=12).
 *    [12 Mars 1995] mseritan: multiline textpad grel, cleared the textpad
 *    code.
 *    [24 April 1995] mseritan: added the new selection code and 
 *    eliminated one annoying global variable. Also changed the call
 *    sequence for function \functiontag{paintgrel}.
 *
 *    \item[25 April 1995] mseritan: online help subsystem and extended keys
 *    handling under the MSDOS operating system.
 *
 *    \item[8 May 1995] mseritan: started the implementation of current grel switching
 *    mechanisms from the keyboard.
 *
 *    \item[11 Nov 1995] mseritan: improving the keyboard module (more keys decodified
 *    under DOS and Linux)
 *
 *    \item[22 Nov 1995] mseritan: romanian diacritical characters
 *
 *    \item[15 Jan 1996] mseritan: porting to libgrx 1.4
 */

#define WIPORT_1                                                /* [DEF] */ 
/*
#define KEYBOARD_RAW
*/
/* BY DEFAULT, PRESERVE WIPORT1 COMPATIBILITY */


#include "wiport2.h" /* [DEF] */ 
#include <malloc.h> /* [DEF] */ 

/* getting NULL */
#include <stdlib.h> /* [DEF] */ 
#include <stdio.h>

/* the GNU DJGPP GRX headers */
#include <grx20.h> /* [DEF] */ 


void _GrMouseGetEvent( int flags, GrMouseEvent * p, int line) {
  GrMouseGetEvent(flags,p);
/*  printf( "line: %d flags: %1x buttons: %d key: %d stat: %1x\n"
	 , line, (p)->flags, (p)->buttons, (p)->key, (p)->kbstat);
  fflush( stdout );*/
}


/*--
  \end{code}

  \chapter{WIPORT2L implementation}

  \ImplementationNotes{
  }
  \Portability{ % What is assumed about the operating environment
  }
  \Changes{ % that are anticipated, if special provision was made for them
  }

  \begin{code}
  --*/


/* Variables that return the shot parameters */

short xspotshot;
short yspotshot;
short xhorshot;
short y0horshot;
short y1horshot;
short x0vershot;
short x1vershot;
short yvershot;
short x0rectshot;
short x1rectshort;
short y0rectshot;
short y1rectshot;

/* Data structures modified by the initialisation function 
 * and functions to read them */

static short maxgwinxsize = 640; /* [VAR] */ 
static short maxgwinysize = 480; /* [VAR] */ 
static short maxgwindepth = 4; /* [VAR] */ 

/* BUG: do not know what happens if we have multiple gwins */
short wi_get_x_res() {return maxgwinxsize;}
short wi_get_y_res() {return maxgwinysize;}
short wi_get_color_res() {return maxgwindepth;}

static short font_x_size; /* [VAR] */ 
static short font_y_size; /* [VAR] */ 
short wi_get_char_x_size() { return font_x_size;}
short wi_get_char_y_size() { return font_y_size;}

/* exception management */

short gwerrno; /* [VAR] */ 

/* colors of the various widgets */
short wi_widget_background = 8;
short wi_widget_darkborder = 4;
short wi_widget_lightborder = 12;

/* local variables */

static GrFont *grxf;                    /* [VAR] */ 
static GrTextOption text_options;       /* [VAR] */
static GrFBoxColors butup;      /* [VAR] */ 
static GrFBoxColors butdown;    /* [VAR] */ 
static GrFBoxColors switchno;   /* [VAR] */ 
static GrFBoxColors switchyes;  /* [VAR] */ 
static GrFBoxColors textpd;     /* [VAR] */
static GrFBoxColors lowdwin;    /* [VAR] */ 
static GrFBoxColors raisedwin;  /* [VAR] */ 
static GrFBoxColors planedwin;  /* [VAR] */ 

static switch_legend_color = 13;/* [VAR] */
static text_color = 1;          /* [VAR] */

GrMouseEvent mev; /* [VAR] */ 


/*--
  \end{code}

  \section{Initialization}

  \ImplementationNotes{
  }
  \Portability{ % What is assumed about the operating environment
  }
  \Changes{ % that are anticipated, if special provision was made for them
  }

  \funparagraph{wi\_initiate}  % The name of the function(s)
  \ImplementationNotes{
  % How implementation of the function is done: algorithm---if special,
  % implementation decisions, discarded implementation alternatives
  }
  \Portability{ % What is assumed about the operating environment
  }
  \Changes{ % that are anticipated, if special provision was made for them
  }

  \begin{code}
  --*/

/* current grel */
static struct selection current_sel={NULL};

short wiportinit(void * display, int screen, short visual_choice, int argc, char ** argv) { /* [FUN] */
  /* load the font, exit if font not found */
  grxf = GrLoadFont("wiport.fnt"); 
  if( grxf == NULL ) {
    fprintf( stderr, "I could not locate the font.\n" );
    exit( -1 );
  }
  /* initialize the text options structure
   * in order to be able to use the above font.
   */
  memset( &text_options, 0, sizeof(text_options));
  text_options.txo_font = grxf;
  text_options.txo_xalign = GR_ALIGN_LEFT;
  text_options.txo_yalign = GR_ALIGN_TOP;
/*
  text_options.txo_xmag = 1;
  text_options.txo_ymag = 1;
*/
  text_options.txo_direct  = GR_TEXT_RIGHT;
  text_options.txo_fgcolor.v = GrBlack();
  text_options.txo_bgcolor.v = 0 /* eventually modify this */;

 /* GrSetMode( GR_default_graphics ); */
 GrSetMode(GR_width_height_color_graphics, 640, 480, 16);
/*  GrSetMode(GR_biggest_noninterlaced_graphics); */
  
  font_x_size = 8;
  font_y_size = 16;
  
  butup.fbx_intcolor= wi_widget_background;
  butup.fbx_topcolor = butup.fbx_leftcolor = wi_widget_lightborder;
  butup.fbx_bottomcolor = butup.fbx_rightcolor = wi_widget_darkborder;

  butdown.fbx_intcolor = wi_widget_background;
  butdown.fbx_topcolor = butdown.fbx_leftcolor = wi_widget_darkborder;
  butdown.fbx_bottomcolor = butdown.fbx_rightcolor = wi_widget_lightborder;

  switchno.fbx_intcolor= wi_widget_background;
  switchno.fbx_topcolor = switchno.fbx_leftcolor = wi_widget_darkborder;
  switchno.fbx_bottomcolor = switchno.fbx_rightcolor = wi_widget_lightborder;

  switchyes.fbx_intcolor = 1;
  switchyes.fbx_topcolor = switchyes.fbx_leftcolor = wi_widget_darkborder;
  switchyes.fbx_bottomcolor = switchyes.fbx_rightcolor = wi_widget_lightborder;

  textpd.fbx_intcolor = wi_widget_background;
  textpd.fbx_topcolor = textpd.fbx_leftcolor = wi_widget_darkborder;
  textpd.fbx_bottomcolor = textpd.fbx_rightcolor = wi_widget_lightborder;

  lowdwin.fbx_intcolor = wi_widget_background;
  lowdwin.fbx_topcolor = lowdwin.fbx_leftcolor = wi_widget_darkborder;
  lowdwin.fbx_bottomcolor = lowdwin.fbx_rightcolor = wi_widget_lightborder;

  raisedwin.fbx_intcolor = wi_widget_background;
  raisedwin.fbx_topcolor = raisedwin.fbx_leftcolor = wi_widget_lightborder;
  raisedwin.fbx_bottomcolor = raisedwin.fbx_rightcolor = wi_widget_darkborder;


  planedwin.fbx_intcolor = wi_widget_background;
  planedwin.fbx_topcolor = planedwin.fbx_leftcolor = wi_widget_lightborder;
  planedwin.fbx_bottomcolor = planedwin.fbx_rightcolor = wi_widget_darkborder;

  current_sel.hitgrel = NULL;

  _allocate_color_codes(16);
  GrMouseEventMode(0);
  GrMouseInit();
  GrMouseSetCursorMode(0);
  GrMouseDisplayCursor();
/*  GrMouseEventEnable(1, 1);*/
}

short wi_initiate()

{
  wiportinit(NULL, 0, 0, 0, NULL);
  return 1;  /* Success */
}


/*--
  \end{code}

  \funparagraph{wi\_terminate}
  \PurposeReturn{
  Dynamically frees all the dynamically allocated data pertaining to WIPORT.
  }
  \Exceptions{
  }
  \GlobalEffects{
  % Global effects on exported or external variables
  }
  \Preconditions{
  % Conditions to be met when the function is called
  }
  \Performance{
  % How it is, not why and what to do about it
  }

  \begin{code}
  --*/

void wiportclose( void )  {
  wi_terminate();
}

short wi_terminate( void ) {
  GrSetMode(GR_default_text,80,25,16);
}

/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
/* THE FOLLOWING CODE MUST BE CONSIDERED OBSOLETE            */
/*                                                           */

#ifdef WIPORT_1

/* IMPLEMENTING THE TECHNOLOGIES */

#define BW 0 /* [DEF] */ 
#define GRAY 1 /* [DEF] */ 
#define COLOR 2 /* [DEF] */ 
#define NOFSGRAYS 16 /* [DEF] */ 
#define NOFSCOLORS 16 /* [DEF] */ 
#define NOFSBWS 16 /* [DEF] */ 

short sgray_pallete[NOFSGRAYS];                                 /* [VAR] */ 
short scol_red[NOFSCOLORS];                                     /* [VAR] */ 
short scol_blue[NOFSCOLORS];
short scol_green[NOFSCOLORS];

short current_screen_tech = GRAY; /* [VAR] */ 
short current_paper_tech = BW; /* [VAR] */ 


   /* seting ``colors'' for each technology in part */

void def_screen_color(short col, short red, short green, short blue) /* [FUN] */ 
{
  long actred, actblue, actgreen;

  actred = red;
  actblue = blue;
  actgreen = green;

  actred *= 256;
  actblue *= 256;
  actgreen *= 256;

  actred /= 10000;
  actblue /= 10000;
  actgreen /= 10000;

  scol_red[col] = actred;
  scol_blue[col] = actblue;
  scol_green[col] = actgreen;

  printf( "GrSetColor: %d %d %d %d.\n", col, actred, actgreen, actblue );
  GrSetColor(col, actred, actgreen, actblue);
}


/* There will be 16 ``colors'' available in the GRAY technology */

void gset_sgrays_color(short col, short amount_of_white) /* [FUN] */ 

/* the amount of white is between 0 and 10,000 */

{
  long actc;

  actc = amount_of_white;
  actc *= 255;
  actc /= 10000;
  sgray_pallete[col] = actc;
  GrSetColor(col, actc, actc, actc);
}

/* Initializing the various technologies */


/* Seting the colors for GRAY SCREEN technology */

set_gray_colors()  /* should use RESOURCE file */               /* [FUN] */ 

{
  short i;
  for(i=0; i<16; i++)
    gset_sgrays_color(i, i*625);
  gset_sgrays_color(0, 8*625);
}

/* Technology initialisation function */

use_color_s_tech()

{
  short i;
  def_screen_color(0, 8*625, 8*625, 8*625);
  for(i=1; i<16; i++)
    def_screen_color(i, i*625, i*625, i*625);
}

/* Read the color values into remote (parallel vector) buffers */

get_screen_colors(short *r, short *g, short *b)

{
  short i;
  long a;

  for(i=0; i<NOFSCOLORS; i++) {
    a = scol_red[i];
    a *= 10000;
    a /= 256;
    r[i] = a;
    a = scol_green[i];
    a *= 10000;
    a /= 256;
    g[i] = a;
    a = scol_blue[i];
    a *= 10000;
    a /= 256;
    b[i] = a;
  }
}

#endif

/*                                                    */
/* THE ABOVE CODE IS OBSOLETE                         */
/* ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
/* THE FOLLOWING CODE MUST BE CONSIDERED OBSOLETE            */
/*                                                           */

#ifdef WIPORT_1

#ifdef MSDOS
/* dummies */
inline cursor_hide() {} /* [FUN] */ 
inline cursor_show() {} /* [FUN] */ 
#else
inline void cursor_hide(void) {
    GrMouseEraseCursor();
}
inline void cursor_show(void) {
    GrMouseDisplayCursor();
}

#endif

/* Function: key_to_sym
 * Warning:  the implementation of this function is dependent of
 *           the libgrx implementation under Linux which is still in
 *           a very unstable state.
 */

long diacritic( long key ) {
  if( key & WIP_ALT ) {
    switch( key & 0x7f ) {
     case 'a': key = 227; break;
     case 'q': key = 226; break;
     case 'i': key = 238; break;
     case 'j': key = 206; break;
     case 's': key = 186; break;
     case 't': key = 254; break;
    }
  }
  return key;
}

#ifdef MSDOS 

long key_to_sym( long key, int state ) {
  if( key> 255 ) key = (key & 0xff) | 0x100;
  switch( key ) {
   case 9:     key = TAB; break;
   case 271:   key = S_TAB; break;
   case 8:     key = BS; break;
   case 0x153: key= DEL; break;
   case 0x147: key= HOME;   break;
   case 0x14f: key= END;    break;
    
   case 0x14b: key=LEFT;   break;
   case 0x148: key=UP;     break;
   case 0x14d: key=RIGHT;  break;
   case 0x150: key=DOWN;   break;
   case 0x13a: key = F1; break;
   case 0x13b: key = F2; break;
   case 0x13c: key = F3; break;
   case 0x13d: key = F4; break;
   case 0x13e: key = F5; break;
   case 0x13f: key = F6; break;
   case 0x140: key = F7; break;
   case 0x141: key = F8; break;
   case 0x142: key = F9; break;
   case 0x143: key = F10; break;
   case 0x157: key = F11; break;
   case 0x158: key = F12; break;
  default:
    break;
  }

  if( state & GR_KB_SHIFT ) key |= WIP_SHIFT;
  if( state & GR_KB_CTRL )  key |= WIP_CTRL;
  if( state & GR_KB_ALT )   key |= WIP_ALT;

  printf("%1x\n", key);
  return key;
}
#else

long key_to_sym( long key, int state ) {
  static int remember=0;

  /*  printf( "key_to_sym: %d [%c] %d\n", key, key, state ); */
  switch( key ) {
   case 0: key = LEFT; break;
   case 1: key = DOWN; break;
   case 3: key = RIGHT; break;
   case 2: key = UP; break;
   case 9: key = TAB; break;
   case 27:			       /* ALT-key in the current Grx */
    remember = 27;
    return 0;
   default:
  }
  if( remember == 27 ) key |= WIP_ALT;
  key = diacritic(key);
  remember = 0;
  return key;
}
#endif

/* key to activate the current selection */
static long action_key = 10;

/* key that change the focus */

enum {NO_FDI                    /* Nope, this key does not change focus */
	, NEXT_FDI              /* Next element in the list, TAB */
	, PREV_FDI              /* Previous element in the list, SHIFT TAB */
	, LEFT_FDI              /* The left spatial element, ARROW LEFT */
	, RIGHT_FDI             /* The right spatial element, ARROW RIGHT */
	, UP_FDI                /* The up spatial element, ARROW UP */
	, DOWN_FDI              /* The down spatial element, ARROW DOWN */
};

int is_change_focus_key( long key ) {
  switch( key ) {
  case TAB: return NEXT_FDI;
  case S_TAB: return PREV_FDI;
  case UP: return UP_FDI;
  case DOWN: return DOWN_FDI;
  case LEFT: return LEFT_FDI;
  case RIGHT: return RIGHT_FDI;
  default: return NO_FDI;
  }
}

short inblockf = 0; /* [VAR] */ 

void enter_graphic_block() /* [FUN] */ 
     
{
  inblockf = 1;
}

void exit_graphic_block() /* [FUN] */ 
     
{
  inblockf = 0;
}

#endif

/*                                                    */
/* THE ABOVE CODE IS OBSOLETE                         */
/* ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/*--
  \end{code}

  \section{Local paint functions}

  \ImplementationNotes{
  }
  \Portability{ % What is assumed about the operating environment
  }
  \Changes{ % that are anticipated, if special provision was made for them
  }

  \begin{code}
  --*/

#ifdef FASTEST_TEXT
/* GrTextXY is using the font built in the vga cards */
#define GraphText(x0,y0,text,col1,col2) GrTextXY(x0, y0, text, col1, col2);

#else  /* FASTEST_TEXT */

#if 0
#define GraphText(x0,y0,text,col1,col2)\
  text_options.txo_fgcolor.v = GrColorValue(col1);\
  text_options.txo_bgcolor.v = col2;\
  GrDrawString( text, strlen(text), x0, y0, &text_options);
#else
#define GraphText(x0,y0,text,col1,col2)\
  text_options.txo_bgcolor.v = col2;\
  GrDrawString( text, strlen(text), x0, y0, &text_options);
#endif

#endif  /* FASTEST_TEXT */

void painttext(GWIN *gw, short x0, short y0, short col1, short col2, char *text) { /* [FUN] */ 
  unview();
  DosClearArea(gw, x0, y0, strlen(text) * font_x_size, font_y_size,
	       col2);
  GraphText(x0, y0, text, col1, col2);
}

int dwin_x_size(GWIN * gw, short d) { /* [FUN] */ 
  return (gw -> dw[d] -> xl);
}

int dwin_y_size(GWIN * gw, short d) { /* [FUN] */ 
  return (gw -> dw[d] -> yl);
}

void paintbutton(GWIN *gw, short x0, short y0, short x1, short y1
		 , char *text, short mode, short current ) { /* [FUN] */ 
  /* paint a button, if mode the button is pressed */
  short back, fore;
  
  unview();
  
  GrFilledBox(x0-5, y0-5, x1+5, y1+5, (current==0) ? 8: 1);
  if(!mode) {
    GrFramedBox(x0, y0, x1, y1, 2, &butup);
    GraphText(x0+(x1-x0)/2 - font_x_size * strlen(text)/2, 
	      y0+(y1-y0)/2 - font_y_size / 2 + 2, text, 1 , 
	      butup.fbx_intcolor);
  } else {
    GrFramedBox(x0, y0, x1, y1, 2, &butdown);
    GraphText(x0+(x1-x0)/2 - font_x_size * strlen(text)/2 + 1, 
	      y0+(y1-y0)/2 - font_y_size / 2 + 3, text, 1, 
	      butup.fbx_intcolor );
  }  
}
     
#define SWXSZ 10 /* external size of switch button */ /* [DEF] */ 
#define SWISZ 6  /* internal size of switch button */ /* [DEF] */ 
     
     void paintswitch(GWIN *gw, short x0, short y0, short x1, short y1, char *text, int mode) /* [FUN] */ 
     
     /* mode is 1 if the switch must be painted as selected */
     
{
  /* Make the space clean */
  
  unview();
  /*  DosClearArea(gw, x0-5, y0-5, x1 - x0, y1 - y0, gw -> gwibackground);*/
  
  /* draw the border of the switch */

  GrFilledBox(x0-5, y0-5, x0+SWISZ+5, y0+SWISZ+5, switchno.fbx_intcolor);
  if(mode)
    GrFramedBox(x0, y0, x0+SWISZ, y0+SWISZ, 1, &switchyes);
  else
    GrFramedBox(x0, y0, x0+SWISZ, y0+SWISZ, 1, &switchno);
  GraphText(x0+SWISZ+10, y0 - 3, text, switch_legend_color, switchno.fbx_intcolor); /*gw->gwibackground);*/
  return ;
}

static DWIN *crtdwin = NULL; /* [VAR] */ 

unview()  /* [FUN] */ 
     
{
  
    if(crtdwin!=NULL) {
    crtdwin = NULL;
    GrResetClipBox();
    }
  
}


void paintline(GWIN *gw, DWIN *dw, short x0, short y0, short x1, short y1, short col, short width, short style, short cap /* ignored for the moment */) /* [FUN] */ 
{
  if(crtdwin!=dw) {
    GrSetClipBox(dw->x0, dw->y0, dw->x0+dw->xl, dw->y0+dw->yl);
    crtdwin = dw;
  }
  GrLine(x0, y0, x1, y1, col);  
}

/*--
\end{code}

\funparagraph{painttextpad}
% The name of the function is expected to be prezent
% in the sectioning element above

\PurposeReturn{}
\Exceptions{}
\GlobalEffects{}
\Preconditions{}
\Performance{}

\begin{code}
--*/

static char cursor_shape[3] = " "; /* [VAR] */

void painttextpad(GWIN *gw, short x0, short y0, short x1, short y1
		  , struct _tp_ext * ext, short current ) { /* [FUN] */
  short nl;
  
  nl = (y1 - y0) / font_y_size;
  /* clear the area under the textpad */
  unview();
  if(_tp_cursor_row(ext)==-1) {
    GrFilledBox(x0-5, y0-5, x1+font_x_size+14, y1+5
		, (current == 0) ? textpd.fbx_intcolor: wi_widget_background);
    GrFramedBox(x0, y0, x1+font_x_size+9, y1, 2, &textpd);
  }
  if(_tp_cursor_row(ext)>-1)
    GrFilledBox(x0, y0, x1+font_x_size+9, y1, textpd.fbx_intcolor);

  {
    int first_line;             /* first line to be displayed */
    int last_line;              /* last line to be displayed */
    int line;                   /* current line in the buffer */
    int y;                      /* vertical screen position */
    char save;			/* last character on a line */

    /* select the first and last lines to be displayed */
    first_line = 0; 
    if( _tp_cursor_line(ext) >= nl ) first_line = _tp_cursor_line(ext)-nl+1;
    last_line = first_line+nl;
    if( last_line > ext->line_nb ) last_line = ext->line_nb;
    
    /* display the selected lines */
    for(  y = y0+2, line = first_line
	; line<last_line
	; y += font_y_size, line++ ) {
      
      save = _tp_access_line(ext,line)[_tp_line_length(ext, line)];
      _tp_access_line(ext,line)[_tp_line_length(ext, line)] = 0;

      GraphText(x0+2, y, _tp_access_line(ext,line), 1, textpd.fbx_intcolor);
     _tp_access_line(ext,line)[_tp_line_length(ext, line)] = save;
    }
    if( _tp_cursor_row(ext) > -1 ) {
      int x,y;                  /* position of the cursor */
      cursor_shape[0] = _tp_access_line(ext, _tp_cursor_line(ext))
			      [_tp_cursor_row(ext)];
      if(cursor_shape[0]<33 || cursor_shape[0]>126)
	cursor_shape[0] = ' ';
      
      x = 2+font_x_size*_tp_cursor_row(ext);
      y = (_tp_cursor_line(ext) - first_line ) * font_y_size;
      if( x<x1 ) 
	GraphText( x0+x, y0+y+2, cursor_shape, textpd.fbx_intcolor, 1);
    }
  };
}


/*--
  \end{code}

  \section{Graphic space implementation}

  \ImplementationNotes{
  }
  \Portability{ % What is assumed about the operating environment
  }
  \Changes{ % that are anticipated, if special provision was made for them
  }

  \funparagraph{wi\_new\_gwin}
  \ImplementationNotes{
  % How implementation of the function is done: algorithm---if special,
  % implementation decisions, discarded implementation alternatives
  }
  \Portability{ % What is assumed about the operating environment
  }
  \Changes{
  The number of colors will currently be the maximum available.
  }

  \begin{code}
  --*/


GWIN *newgwin(short xl, short yl, char *gwititle, char *gwictitle) { /* [FUN] */ 
  GWIN *rg;
  short i;
  /* some checks are done here */
  
  if(xl>maxgwinxsize)
    {
      wraise( "EGwinXSize" );
      return NULL;
    }
  if(yl>maxgwinysize)
    {
      wraise( "EGwinYSize" );
      return NULL;
    }
  rg = (GWIN *)malloc(sizeof(struct _gwin));
  if(rg==NULL)
    {
      wraise( "EMem" );
      return NULL;
    }
  strncpy(rg->gwiconn, gwictitle, GWICONNSIZE);
  strncpy(rg->gwinn, gwititle, GWINNSIZE);
  rg->gwibackground = 0;
  rg->gwiforeground = 7;
  rg->dwinfill = 0;
  for(i=0; i<DWINSPERGWIN; i++)
    rg->dw[i] = NULL;

  /* initialize the help subsystem */
  rg->help_on = -1;
  rg->help_dwin = -1;
  

  if (newdwin(rg, 0, 0, xl, yl) == -1) {
    free(rg -> dw[0]);
    return NULL;
  }
  _register_gwin(rg);
  return rg;
}

gwin wi_new_gwin(pixed xsize, pixed ysize, short ncolors)

{
  newgwin(xsize, ysize, "Wiport2", "Wiport2");
  return wi_get_crt_gwin();
}


/*--
  \end{code}

  \funparagraph{wi\_set\_gwin\_name}
  \ImplementationNotes{
  % How implementation of the function is done: algorithm---if special,
  % implementation decisions, discarded implementation alternatives
  }
  \Portability{ % What is assumed about the operating environment
  }
  \Changes{ % that are anticipated, if special provision was made for them
  }

  \begin{code}
  --*/

short wi_set_gwin_name(char *t)

{
  return 1;
  /* allways success, nothing to be done in a non-windowing environment */
}


/*--
  \end{code}

  \funparagraph{wi\_get\_x\_char\_size, wi\_get\_y\_char\_size}
  \ImplementationNotes{
  % How implementation of the function is done: algorithm---if special,
  % implementation decisions, discarded implementation alternatives
  }
  \Portability{ % What is assumed about the operating environment
  }
  \Changes{ % that are anticipated, if special provision was made for them
  }

  \begin{code}
  --*/

pixed wi_get_x_char_size() { return font_x_size; }
pixed wi_get_y_char_size() { return font_y_size; }

/*--
  \end{code}

  \section{Dwin management}

  \ImplementationNotes{
  % How implementation of the whole package is done: algorithms---if special,
  % implementation decisions, discarded implementation alternatives
  }
  \Portability{ % What is assumed about the operating environment
  }
  \Changes{ % that are anticipated, if special provision was made for them
  }

  \funparagraph{wi\_new\_dwin}
  \ImplementationNotes{
  % How implementation of the function is done: algorithm---if special,
  % implementation decisions, discarded implementation alternatives
  }
  \Portability{ % What is assumed about the operating environment
  }
  \Changes{ % that are anticipated, if special provision was made for them
  }

  \begin{code}
  --*/


short newdwin(GWIN *gw, short x0, short y0, short xl, short yl) { /* [FUN] */ 
  if(gw->dwinfill>=DWINSPERGWIN)
    {
      wraise("ETooManyDwin");
      return -1;
    }
  gw->dw[gw->dwinfill] = dwalloc(x0, y0, xl, yl);
  if(gw->dw[gw->dwinfill]==NULL)
    {
      wraise( "EMem" );
      return -1;
    }
  gw->dw[gw->dwinfill]->bgd_color = gw->gwibackground;
  gw->dwinfill ++;
  return (gw->dwinfill - 1);
}

dwin wi_new_dwin(pixed x0, pixed y0, pixed xl, pixed yl)

{
  return newdwin(wi_crt_gwin_ptr(), x0, y0, xl, yl);
}


/*--
  \end{code}

  \funparagraph{wi\_clear\_dwin}  % The name of the function(s)
  \ImplementationNotes{
  We gave up associating dwins with borders of different sizes or
  sculptures. It is probably preferable for the user to draw borders
  himself, in the larger dwin, than to remember the mechanisms involved in
  defining and maintaining dwin borders. Complete coverage of issues
  such as border direction, size, color(s), etc would have complicated
  things a lot. Instead, borders may be associated later with rectangles.

  We gave up having a background color in every dwin, as this will be easy
  to resolve with rectangles filled with the given color. At least two
  more functions are cut this way.
  }
  \Portability{ % What is assumed about the operating environment
  }
  \Changes{
  Background color and optional dwin mapping must be addressed separately.
  }

  \begin{code}
  --*/


void DosClearArea(GWIN * gw, short x0, short y0, short xl, short yl, short col) { /* [FUN] */ 
  GrFilledBox(x0, y0, x0+xl, y0+yl, col);
}

void DosFillRectangle(GWIN * gw, short x0, short y0, short xl, short yl) { /* [FUN] */ 
  GrFilledBox(x0, y0, x0+xl, y0+yl, gw -> gwiforeground);
}


void cleardwin(GWIN * gw, short d, short style) { /* [FUN] */
  unview();
  switch(style) {
  case LOWERED_DWIN:
    GrFilledBox(gw->dw[d]->x0 - 7, gw->dw[d]->y0 - 7,
	      gw->dw[d]->x0 + gw->dw[d]->xl + 7,
	      gw->dw[d]->y0 + gw->dw[d]->yl + 7,
	      lowdwin.fbx_intcolor);
    GrFramedBox(gw->dw[d]->x0, gw->dw[d]->y0,
		gw->dw[d]->x0 + gw->dw[d]->xl,
		gw->dw[d]->y0 + gw->dw[d]->yl, 3, &lowdwin);
    gw->dw[d]->bgd_color = lowdwin.fbx_intcolor;
    break;
  case RAISED_DWIN:
    GrFilledBox(gw->dw[d]->x0 - 7, gw->dw[d]->y0 - 7,
	      gw->dw[d]->x0 + gw->dw[d]->xl + 7,
	      gw->dw[d]->y0 + gw->dw[d]->yl + 7,
	      raisedwin.fbx_intcolor);
    GrFramedBox(gw->dw[d]->x0, gw->dw[d]->y0,
		gw->dw[d]->x0 + gw->dw[d]->xl,
		gw->dw[d]->y0 + gw->dw[d]->yl, 3, &raisedwin);
    gw->dw[d]->bgd_color = raisedwin.fbx_intcolor;
    break;
  case PLANE_DWIN:
  default:
    DosClearArea(gw,gw->dw[d]->x0, gw->dw[d]->y0,
		 gw->dw[d]->xl, gw->dw[d]->yl, planedwin.fbx_intcolor);
    gw->dw[d]->bgd_color = planedwin.fbx_intcolor;
    break;
  }
  _dwin_clear(gw -> dw[d]);
}


short wi_clear_dwin(dwin d, short style)

{
  cleardwin(wi_crt_gwin_ptr(), d, style);  
}

void free_dwin(dwin d)

{
  GWIN *g;
  g = wi_crt_gwin_ptr();
  _dwin_clear(g->dw[d]);
}


/*--
  \end{code}

  \funparagraph{wi\_redraw_area}
  \ImplementationNotes{
  % How implementation of the function is done: algorithm---if special,
  % implementation decisions, discarded implementation alternatives
  }
  \Portability{ % What is assumed about the operating environment
  }
  \Changes{ % that are anticipated, if special provision was made for them
  }

  \begin{code}
  --*/

void redwin(GWIN *gw, short d, short x0, short y0, short xl, short yl);

short wi_redraw_area(dwin d, pixed x0, pixed y0, pixed xl, pixed yl)

{
  redwin(wi_crt_gwin_ptr(), d, x0, y0, xl, yl);
  return 0;
}



/*--
  \end{code}

  \section{Object description}

  \ImplementationNotes{
  }
  \Portability{ % What is assumed about the operating environment
  }
  \Changes{ % that are anticipated, if special provision was made for them
  }

  \begin{code}
  --*/

/* prototype for a local function */
static void paintgrel(GWIN * gw, DWIN * dw, struct _grel * g );


/*--
  \end{code}

  \funparagraph{wi\_plot}
  \ImplementationNotes{
  % How implementation of the function is done: algorithm---if special,
  % implementation decisions, discarded implementation alternatives
  }
  \Portability{ % What is assumed about the operating environment
  }
  \Changes{ % that are anticipated, if special provision was made for them
  }

  \begin{code}
  --*/

static short last_plot_grel = -1;

void gpoint(GWIN * gw, short d, short x, short y) { /* [FUN] */ 
  if(!inblockf)
    cursor_hide();
  /*  _setcolor(gw -> dw[d] -> cr_col);
      _setpixel(gw -> dw[d] -> x0 + x, gw -> dw[d] -> y0); */
  GrPlot(gw -> dw[d] -> x0 + x, gw -> dw[d] -> y0 + y, gw -> dw[d] -> cr_col);
  if(!inblockf)
    cursor_show();
  last_plot_grel =
    defintpoint(gw -> dw[d], gw -> dw[d] -> x0 + x,
		gw -> dw[d] -> y0, gw -> dw[d] -> cr_col);
  return;
}

ugrel wi_plot(dwin d, pixed x, pixed y)

{
  gpoint(wi_crt_gwin_ptr(), d, x, y);
  return make_ugrel(wi_get_crt_gwin(), d, last_plot_grel);
}


/*--
  \end{code}

  \funparagraph{wi\_line}  % The name of the function(s)
  \ImplementationNotes{
  % How implementation of the function is done: algorithm---if special,
  % implementation decisions, discarded implementation alternatives
  }
  \Portability{ % What is assumed about the operating environment
  }
  \Changes{ % that are anticipated, if special provision was made for them
  }

  \begin{code}
  --*/

short last_line_grel = -1;

void gmoveto(GWIN *gw, short d, short x, short y) /* [FUN] */ 
     
{
  gw->dw[d]->cr_draw_x = x;
  gw->dw[d]->cr_draw_y = y;
}

void wi_move( short d, short x, short y ) {
  gmoveto(wi_crt_gwin_ptr(), d, x, y);
}
    

void glineto(GWIN *gw, short d, short x, short y) /* [FUN] */ 
     
{
  if(!inblockf)
    cursor_hide();
  paintline(gw, gw->dw[d],
	    gw->dw[d]->x0+gw->dw[d]->cr_draw_x,
	    gw->dw[d]->y0+gw->dw[d]->cr_draw_y,
	    gw->dw[d]->x0+x,
	    gw->dw[d]->y0+y, gw->dw[d]->cr_col,
	    gw->dw[d]->cr_width, gw->dw[d]->cr_style, gw->dw[d]->cr_cap);
  if(!inblockf)
    cursor_show();
  last_line_grel =
    defintline(gw->dw[d], gw->dw[d]->cr_draw_x, gw->dw[d]->cr_draw_y,
	     x, y, gw->dw[d]->cr_col,
	     gw->dw[d]->cr_width, gw->dw[d]->cr_style, 
	     gw->dw[d]->cr_cap); 
  gw->dw[d]->cr_draw_x = x;
  gw->dw[d]->cr_draw_y = y;
  return ;
}

ugrel wi_line(dwin d, pixed x0, pixed y0, pixed x1, pixed y1)

{
  GWIN *g;

  gmoveto( g =wi_crt_gwin_ptr(), d, x0, y0);
  glineto(g, d, x1, y1);
  return make_ugrel(wi_get_crt_gwin(), d, last_line_grel);
}

/*--
\end{code}

\funparagraph{wi\_rect}  % The name of the function(s)
\ImplementationNotes{ 
}
\Portability{ % What is assumed about the operating environment
}
\Changes{ % that are anticipated, if special provision was made for them
}

\begin{code}
--*/

ugrel wi_rect(dwin d, pixed x0, pixed y0, pixed xl,  pixed yl ) {
  DWIN * the_dwin;
  short the_grel;

  the_dwin = wi_crt_gwin_ptr()->dw[d];
  the_grel = defintrect( the_dwin, x0, y0, x0+xl, y0+yl, the_dwin->cr_col );
  /* set the clip box to the proper dwin */
  if(crtdwin!=the_dwin) {
    GrSetClipBox(the_dwin->x0, the_dwin->y0
		 , the_dwin->x0+the_dwin->xl, the_dwin->y0+the_dwin->yl);
    crtdwin = the_dwin;
  }
  paintgrel( wi_crt_gwin_ptr(), the_dwin, ndx_to_grel( the_dwin, the_grel ) );
  return make_ugrel(wi_crt_gwin_ptr(), d, the_grel);
}


/*--
  \end{code}

  \funparagraph{wi\_button}  % The name of the function(s)
  \ImplementationNotes{
  % How implementation of the function is done: algorithm---if special,
  % implementation decisions, discarded implementation alternatives
  }
  \Portability{ % What is assumed about the operating environment
  }
  \Changes{ % that are anticipated, if special provision was made for them
  }

  \begin{code}
  --*/

short last_button_grel = -1;

int defbutton(GWIN *gw, short d, short x0, short y0, short xl, short yl, char *text, short key) /* [FUN] */ 
     
     /* returns 1 if success, 0 if failure */
     
{
/*  cursor_hide();*/
  paintbutton(gw, gw->dw[d]->x0+x0, gw->dw[d]->y0+y0, 
	      gw -> dw[d] -> x0 + x0 + xl,  gw -> dw[d] -> y0 + y0 + yl
	      , text, 0, 0);
/*  cursor_show();*/
  return defintbutton(gw->dw[d], x0, y0, xl, yl, text, key);
}


ugrel wi_button(dwin d, pixed x0, pixed y0, pixed xl, pixed yl,
		char *t, wi_keycode key)

{
  GWIN *g;
 
  key = key & 0x00ff;
/*  printf("Button wi_keycode is %x which is '%c'", key, key); */
  last_button_grel = defbutton(g =wi_crt_gwin_ptr(), d, x0, y0, xl, yl, t, key);
  return make_ugrel(wi_get_crt_gwin(), d, last_button_grel);
}

static wi_keycode button_key;

void _set_button_key(short k)

{ button_key = k; }

ugrel _wi_button(dwin d, pixed x0, pixed y0, pixed xl, pixed yl,
		char *t)

{
  GWIN *g;
 
/*  printf("Button wi_keycode is %x which is '%c'", button_key, button_key);*/
  last_button_grel = defbutton(g =wi_crt_gwin_ptr(), d, 
			       x0, y0, xl, yl, t, button_key);
  return make_ugrel(wi_get_crt_gwin(), d, last_button_grel);
}


/*--
  \end{code}

  \funparagraph{wi\_hbutton}  % The name of the function(s)
  \ImplementationNotes{
  % How implementation of the function is done: algorithm---if special,
  % implementation decisions, discarded implementation alternatives
  }
  \Portability{ % What is assumed about the operating environment
  }
  \Changes{ % that are anticipated, if special provision was made for them
  }

  \begin{code}
  --*/


int defhbutton(GWIN *gw, short d, short key) /* [FUN] */ 
     
     /* returns 1 if success, 0 if failure */
     
{
  return definthbutton(gw->dw[d], key);
}

ugrel wi_hbutton(dwin d, wi_keycode key)

{
  GWIN *g;

  last_button_grel = defhbutton(g =wi_crt_gwin_ptr(), d, key);
  return make_ugrel(g, d, last_button_grel);
}


/*--
  \end{code}

  \funparagraph{wi\_switch}  % The name of the function(s)
  \ImplementationNotes{
  % How implementation of the function is done: algorithm---if special,
  % implementation decisions, discarded implementation alternatives
  }
  \Portability{ % What is assumed about the operating environment
  }
  \Changes{ % that are anticipated, if special provision was made for them
  }

  \begin{code}
  --*/

static short last_switch_grel = -1;

int defswitch(GWIN *gw, short d, short x0, short y0, short xl, short yl, char *text, short *swv, short key) /* [FUN] */ 
     
     /* returns 1 if success, 0 if failure */
     
{
  int ret_val;
  ret_val = defintswitch(gw->dw[d], x0, y0, xl, yl, text, swv, key);
  cursor_hide();
  paintswitch(gw, gw->dw[d]->x0+x0, gw->dw[d]->y0+y0, 
	      gw->dw[d]->x0+x0 + xl, gw->dw[d]->y0+y0 + yl, text,
	      *swv==key);  /* paint it ``pressed'' if |*swv==key| */
  cursor_show();
  return ret_val;
}


ugrel wi_switch(dwin d, pixed x0, pixed y0, pixed xl, pixed yl,
		char *t, wi_keycode *swv, wi_keycode key)

{
  GWIN *g;

  g =wi_crt_gwin_ptr();
  last_switch_grel = defswitch(g, d, x0, y0, xl, yl, t, swv, key);
  return make_ugrel(g, d, last_switch_grel);
}


/*--
  \end{code}

  \funparagraph{wi\_alt\_switch}
  \ImplementationNotes{
  % How implementation of the function is done: algorithm---if special,
  % implementation decisions, discarded implementation alternatives
  }
  \Portability{ % What is assumed about the operating environment
  }
  \Changes{ % that are anticipated, if special provision was made for them
  }

  \begin{code}
  --*/


int defaltswitch(GWIN *gw, short d, short x0, short y0, short xl, short yl, char *text, short *swv, short key) /* [FUN] */ 
     
     /* returns 1 if success, 0 if failure */
     
{
  cursor_hide();
  paintswitch(gw, gw->dw[d]->x0+x0, gw->dw[d]->y0+y0, 
	      gw->dw[d]->x0+x0 + xl, gw->dw[d]->y0+y0 + yl, text,
	      *swv==key);  /* paint it ``pressed'' if |*swv==key| */
  cursor_show();
  return defintaswitch(gw->dw[d], x0, y0, xl, yl, text, swv, key);
}


ugrel wi_alt_switch(dwin d, pixed x0, pixed y0, pixed xl, pixed yl,
		char *t, wi_keycode *swv, wi_keycode key)

{
  GWIN *g;

  g =wi_crt_gwin_ptr();
  last_switch_grel = defaltswitch(g, d, x0, y0, xl, yl, t, swv, key);
  return make_ugrel(g, d, last_switch_grel);
}


/*--
  \end{code}

  \funparagraph{wi\_text}
  \ImplementationNotes{
  % How implementation of the function is done: algorithm---if special,
  % implementation decisions, discarded implementation alternatives
  }
  \Portability{ % What is assumed about the operating environment
  }
  \Changes{ % that are anticipated, if special provision was made for them
  }

  \begin{code}
  --*/

short last_text_grel;

int gtext(GWIN *gw, short d, short x, short y, char *text) /* [FUN] */ 
     
{
  last_text_grel = definttext(gw->dw[d], x, y, gw -> dw[d] -> cr_col, text);
  cursor_hide();
  painttext(gw, gw->dw[d]->x0+x, gw->dw[d]->y0+y, gw -> dw[d] -> cr_col,
    gw->dw[d]->bgd_color, text);
  cursor_show();
}

ugrel wi_text(dwin d, pixed x, pixed y, short tsize, char *text)

{
  GWIN *g;

  g =wi_crt_gwin_ptr();
  gtext(g, d, x, y, text);
  return make_ugrel(g, d, last_text_grel);
}

/*--
  \end{code}

  \funparagraph{wi\_textpad}
  \ImplementationNotes{
  % How implementation of the function is done: algorithm---if special,
  % implementation decisions, discarded implementation alternatives
  }
  \Portability{ % What is assumed about the operating environment
  }
  \Changes{ % that are anticipated, if special provision was made for them
  }

  \begin{code}
  --*/

ugrel wi_textbuffer(dwin d, pixed x, pixed y, pixed nc, pixed nl
		 , short size, char *text, wi_keycode key)

{
  GWIN *gw;

  gw = wi_crt_gwin_ptr();
  last_text_grel =
    definttextpad(gw->dw[d], x, y, nc, nl, text, size, key);
  if( last_text_grel > -1 ) { 
    cursor_hide();
    painttextpad(gw, gw->dw[d]->x0+x, gw->dw[d]->y0+y
		 , gw->dw[d]->x0+x+nc*font_x_size
		 , gw->dw[d]->y0+y+nl*font_y_size+1
		 , ndx_to_grel(gw->dw[d], last_text_grel)->ext, 0);
    cursor_show();
  }
  return make_ugrel(gw, d, last_text_grel);
}

int deftextpad(GWIN * gw, short d, short x, short y, short nc, short nl,
               short size, char * buffer, short key) {
  wi_textbuffer( d, x, y, nc, 1, size, buffer, key );
  }

ugrel wi_textpad(dwin d, pixed x, pixed y, pixed nc, pixed nl
		 , short size, char *text, wi_keycode key) {
  return wi_textbuffer( d, x, y, nc, 1, size, text, key );
  }

/*--
  \end{code}

  \section{Interaction utility functions}

  \ImplementationNotes{
  % How implementation of the whole package is done: algorithms---if special,
  % implementation decisions, discarded implementation alternatives
  }
  \Portability{ % What is assumed about the operating environment
  }
  \Changes{ % that are anticipated, if special provision was made for them
  }

  \begin{code}
  --*/


static struct _grel * toggle_key(struct _grel * g) { /* [FUN] */ 
  if (g -> swvval)
    g -> swvval = 0;
  else
    g -> swvval = g -> gkey;
  return g;
}


/*--
  \end{code}

  \section{Editing functions}

  \ImplementationNotes{
  % How implementation of the whole package is done: algorithms---if special,
  % implementation decisions, discarded implementation alternatives
  }
  \Portability{ % What is assumed about the operating environment
  }
  \Changes{ % that are anticipated, if special provision was made for them
  }

  \funparagraph{wi\_inchg\_text\_val}
  \ImplementationNotes{
  % How implementation of the function is done: algorithm---if special,
  % implementation decisions, discarded implementation alternatives
  }
  \Portability{ % What is assumed about the operating environment
  }
  \Changes{ % that are anticipated, if special provision was made for them
  }

  \begin{code}
  --*/




void gset_tp_contents(GWIN *gw, short d, short key, char *cts)

{
  struct _grel *g;
  short i;
  struct selection sel;

  get_key_selection(&sel, gw, key);
  g = sel.hitgrel;
  if(g==NULL)
    return;  /* no such key */
  if(g->gtype!=TEXTPADGREL && g->gtype!=BUFFERGREL )
    return;  /* grel is not a textpad */
  if(g->ext==NULL) {
    wraise( "EBadTextpad" );
    return;  /* grel is badly allocated */
  }
  _tp_contents( g->ext, cts, g->x1-g->x0 );
  paintgrel(gw, sel.lasthitdwin, g);
}

void wi_inchg_text_val(dwin d, wi_keycode key, char *cts)

{
  GWIN *g;

  g = wi_crt_gwin_ptr();
  gset_tp_contents(g, d, key, cts);
}

/*--
  \end{code}

  \section{Parameter seting functions}

  \ImplementationNotes{
  % How implementation of the whole package is done: algorithms---if special,
  % implementation decisions, discarded implementation alternatives
  }
  \Portability{ % What is assumed about the operating environment
  }
  \Changes{ % that are anticipated, if special provision was made for them
  }

  \begin{code}
  --*/
void gsetcolor(GWIN *gw, short d, short col) /* [FUN] */ 
     
{
  gw->dw[d]->cr_col = col;
}


void wi_set_color(short d, colorcode c)

{
  GWIN *g;

  g = wi_crt_gwin_ptr();
  gsetcolor(g, d, c);
}

void gsetlinestyle(GWIN *gw, short d, short mask) /* [FUN] */ 
     
{
  gw->dw[d]->cr_style = mask;
}

void gsetlinewidth(GWIN *gw, short d, short width) /* [FUN] */ 
     
{
  gw->dw[d]->cr_width = width;
}

void gsetlinecap(GWIN *gw, short d, short cap) /* [FUN] */ 
     
{
  gw->dw[d]->cr_cap = cap;
}



void paintgrel(GWIN * gw, DWIN * dw, struct _grel * g )  { /* [FUN] */ 
  /* paints a grel on the screen */
  short nb, * ext;
  short lastx, lasty;
  
  switch(g->gtype) {
  case POINTGREL:
/*  case MULTIPOINTGREL:*/
/*    _setcolor(dw -> cr_col);*/
    GrPlot(dw -> x0 + g -> x0, dw -> y0 + g -> y0, dw -> cr_col);
    ext = g -> ext;
    for (nb = g -> extfill; nb; nb -= 2, ext += 2) {
      GrPlot(ext[0], ext[1], dw -> cr_col);
    }
    break;
  case RECTGREL:
    GrFilledBox( dw->x0 + g->x0, dw->y0 + g->y0,
		dw->x0 + g->x1, dw->y0 + g->y1, g->gcolor);
    break;
  case BUTTONGREL:
    paintbutton(gw, dw->x0 + g->x0, dw->y0 + g->y0,
		dw->x0 + g->x1, dw->y0 + g->y1, g->ext, g->swvval, 0);
    break;
  case SWITCHGREL:
  case ASWITCHGREL:
    paintswitch(gw, dw->x0 + g->x0, dw->y0 + g->y0,
		dw->x0 + g->x1, dw->y0 + g->y1, g->ext,
		g->gkey==g->swvval);
    break;
  case LINEGREL:
/*  case MULTILINEGREL:*/
    paintline(gw, dw, dw->x0 + g->x0, dw->y0 + g->y0,
	      dw->x0 + g->x1, dw->y0 + g->y1,
	      g->gcolor, g->gsize, g->gstyle, g->gcap);
    lastx = dw->x0 + g->x1;
    lasty = dw->y0 + g->y1;
    ext = g -> ext;
    for (nb = g -> extfill; nb; nb -= 2, ext += 2) {
      GrLine(lastx, lasty, ext[0], ext[1], g->gcolor);
      lastx = ext[0];
      lasty = ext[1];
    }
    break;
  case TEXTGREL:
    painttext(gw, dw->x0 + g->x0,
	      dw->y0 + g->y0, g->gcolor, dw->bgd_color, g->ext);
    break;
  case TEXTPADGREL:
    painttextpad(gw, dw->x0 + g->x0, dw->y0 + g->y0,
		 dw->x0 + g -> x1, dw->y0 + g -> y1, g->ext, 0 );
    break;
  case BITMAPGREL:
    
    break;
  case HBUTTONGREL:
  default:
    break;
  }     
}

/* paints a grel marked as current */
static void paintgrel_current( GWIN *gw,  DWIN * dw, struct _grel *  g ) {
  switch( g->gtype ) {
  case BUTTONGREL:
    paintbutton(gw, dw->x0 + g->x0, dw->y0 + g->y0
		, dw->x0 + g->x1, dw->y0 + g->y1, g->ext
		, g->swvval, 1 );
    break;
  case TEXTPADGREL:
    painttextpad(gw, dw->x0 + g->x0, dw->y0 + g->y0,
		 dw->x0 + g -> x1, dw->y0 + g -> y1, g->ext, 1 );
    break;
  }
}

void redwin(GWIN *gw, short d, short x0, short y0, short xl, short yl) /* [FUN] */ 
{
  struct _grel *g;
  short i, j;
  DWIN * dw;
  
#define GREL_IN_WINDOW(g) ((g->x0 >= x0 && g->x0 < xl && g->y0 >= y0 \
			    && g->y0 < yl) || \
			   (g->x1 >= x0 && g->x1 < xl && g->y1 >= y0 \
			    && g->y1 < yl))
  dw = gw->dw[d];
  cursor_hide();
  if(x0==0 && y0==0 && xl==0 && yl==0)
    {
      xl = dw->xl;
      yl = dw->yl;
    }
  /* for all the full pages */
  for(i=0; i<dw->gpfill - 1 ; i++)
    for(j=0; j< NOGPERPAGE; j++)
      {
	g = dw->gp[i] + j;
	if (GREL_IN_WINDOW(g))
	  paintgrel(gw, dw, g);
      }
  /* for the last page */
  i = dw -> gpfill - 1;
  for(j=0; j<dw->gppfill; j++)
    {
      g = dw->gp[i] + j;
      if (GREL_IN_WINDOW(g))
	paintgrel(gw, dw, g);
    }
  cursor_show();
}


/*--
  \end{code}

  \section{Interaction functions}

  \ImplementationNotes{
  % How implementation of the whole package is done: algorithms---if special,
  % implementation decisions, discarded implementation alternatives
  }
  \Portability{ % What is assumed about the operating environment
  }
  \Changes{ % that are anticipated, if special provision was made for them
  }

  \begin{code}
  --*/


void setspotshot(GWIN *gw, short d, short key) /* [FUN] */ 
     
{
  gw->dw[d]->spotshotkey = key;
}

void sethorshot(GWIN *gw, short d, short key) /* [FUN] */ 
     
{
  gw->dw[d]->horshotkey = key;
}

void setvershot(GWIN *gw, short d, short key) /* [FUN] */ 
     
{
  gw->dw[d]->vershotkey = key;
}

void setrectshot(GWIN *gw, short d, short key) /* [FUN] */ 
     
{
  gw->dw[d]->rectshotkey = key;
}

void _locate_next_selection( GWIN * gw, struct selection * sel
				       ,  struct selection * next ) {
  /* locate the next selectable grel in the display list */
  ITERATOR it;
  struct _grel * g;                /* commodity variable */
  struct _grel * first_sel;        /* first selectable grel in dwin */
  int dwin_ndx;                    /* index of the processed dwin */

  /* initialize the local variables */
  first_sel = NULL;
  g = sel->hitgrel;

  /* initialize the result */
  next->hitgrel = NULL;
  if( g == NULL ) {
    /* first time call */
    dwin_ndx = gw->dwinfill-1;
    next->lasthitdwin_ndx = dwin_ndx;
    next->lasthitdwin = gw->dw[ dwin_ndx ];
  } else {
    /* going on from the last selection */
    next->lasthitdwin = sel->lasthitdwin;
    dwin_ndx = next->lasthitdwin_ndx = sel->lasthitdwin_ndx;
  }

  init_fwd_grel_iterator(gw,dwin_ndx,&it);
  /* locate the actual grel
   * and also the first selectable grel, just in case */
  while( check_upper_bound_grel( &it ) && (access_grel( &it ) != g ) ) {
    if( _is_selectable_grel( access_grel( &it ) )  
       && (first_sel == NULL)) {
      first_sel = access_grel( &it );
    }
    iterator_forward( &it );
  }
  /* setup the result to return the first selectable grel, just in case */
  next->hitgrel = first_sel;
  /* if grel not found simply return */
  if( access_grel( &it ) != g ) {
    return;
  }
  /* bypass the actual grel */
  iterator_forward( &it );
  /* look for next textpad */
  for( ; check_upper_bound_grel( &it ); iterator_forward( &it ) )  {
    if( _is_selectable_grel( access_grel( &it )) ) {
      next->hitgrel = access_grel( &it );
      return;
    }
  }
  /* no next grel in the display list for the current dwin
   * return the first selectable one, this was setup previously */
}

void _locate_prev_selection( GWIN * gw, struct selection * sel
				       ,  struct selection * next ) {
  /* locate the next selectable grel in the display list */
  ITERATOR it;
  struct _grel * g;                /* commodity variable */
  struct _grel * first_sel;        /* first selectable grel in dwin */
  int dwin_ndx;                    /* index of the processed dwin */

  /* initialize the local variables */
  first_sel = NULL;
  g = sel->hitgrel;

  /* initialize the result */
  next->hitgrel = NULL;
  if( g == NULL ) {
    /* first time call */
    dwin_ndx = gw->dwinfill-1;
    next->lasthitdwin_ndx = dwin_ndx;
    next->lasthitdwin = gw->dw[ dwin_ndx ];
  } else {
    /* going on from the last selection */
    next->lasthitdwin = sel->lasthitdwin;
    dwin_ndx = next->lasthitdwin_ndx = sel->lasthitdwin_ndx;
  }

  init_bwd_grel_iterator(gw,dwin_ndx,&it);
  /* locate the actual grel
   * and also the first selectable grel, just in case */
  while( check_lower_bound_grel( &it ) && (access_grel( &it ) != g ) ) {
    if( _is_selectable_grel( access_grel( &it ) )  
       && (first_sel == NULL)) {
      first_sel = access_grel( &it );
    }
    iterator_backward( &it );
  }
  /* setup the result to return the first selectable grel, just in case */
  next->hitgrel = first_sel;
  /* if grel not found simply return */
  if( access_grel( &it ) != g ) {
    return;
  }
  /* bypass the actual grel */
  iterator_backward( &it );
  /* look for next selectable grel */
  for( ; check_lower_bound_grel( &it ); iterator_backward( &it ) )  {
    if( _is_selectable_grel( access_grel( &it )) ) {
      next->hitgrel = access_grel( &it );
      return;
    }
  }
  /* no next grel in the display list for the current dwin
   * return the first selectable one, this was setup previously */
}

void _locate_selection( GWIN * gw, struct selection * sel
		      ,  struct selection * next
		      , int fdi) {
  switch( fdi ) {
  case PREV_FDI:
  case UP_FDI:
  case  LEFT_FDI:
    _locate_prev_selection( gw, sel, next );
    break;
  case NEXT_FDI:
    _locate_next_selection( gw, sel, next );
  case DOWN_FDI:
  case RIGHT_FDI:
    _locate_next_selection( gw, sel, next );
    break;
  default:
    /* signal some kind of exception */
    break;
  }
}

void wi_set_crt_ingrel( ugrel g ) {
  DWIN * dw;
  
  if( g == 0 ) {
    current_sel.hitgrel == NULL;
  }
  dw = wi_crt_gwin_ptr()->dw[dwin_of_ugrel(g)];
  current_sel.hitgrel= ndx_to_grel( dw, grel_of_ugrel( g ));
  current_sel.lasthitdwin = dw;
  current_sel.lasthitdwin_ndx = dwin_of_ugrel(g);
}

/* very simple implementation for a key queue */
static  long key_queue = -1;
static __inline__ key_q_empty() {return key_queue==-1;}
static __inline__ key_q_pop()  { long temp; temp=key_queue; key_queue = -1;
			  return temp;}
static __inline__ key_q_push(key) {key_queue = key;}

#ifdef MSDOS
#undef  GR_M_POLL
#define GR_M_POLL 0
#endif

short wi_interact( void ) {
  return gwinteract( wi_crt_gwin_ptr() );
}

void wait_m_button_up( void ) {
  GrMouseEvent mev;
  return;
  do {
    _GrMouseGetEvent( (GR_M_BUTTON_UP| GR_M_POLL), &mev, __LINE__ );
  } while( mev.flags & GR_M_BUTTON_DOWN );
}

#define GWINTERACT_RETURNS_WHEN_CHANGING_FOCUS

short gwinteract(   GWIN * gw  ) { /* [FUN] */ 
  struct _grel * g;      /* the current selected grel */
  short key, d;
  short kbused;          /* flag set if grel selected through keyboard */
  char *previous_help;   /* used to eliminate unnecessary help updatings */
  struct selection sel;  /* communication area with the selection package */

  /* initialization of the main gwinteract loop */
  previous_help = NULL;
  sel.hitgrel = NULL;

# if 0  
  /* make them know there is a current grel */
  if( current_sel.hitgrel != NULL ) {
    cursor_hide();
    paintgrel_current( gw, current_sel.lasthitdwin
		      , current_sel.hitgrel );
    cursor_show();
  }
# endif

  /* wi_interact  main loop */
  puts( "Entering wi_interact.\n" );
  while (1) {
#ifdef SELECTED_TEXTPAD_IS_ACTIVE
    /* if the current grel is a textpad and there is no key,
     * activate the current textpad
     * and goto the main processing loop
     */
    if( ( sel.hitgrel == NULL )
      && key_q_empty()
      && (current_sel.hitgrel != NULL )
      && (current_sel.hitgrel->gtype == TEXTPADGREL) ) {
      memcpy( &sel, &current_sel, sizeof(sel));
      /* faking a keyboard interaction to avoid to get stuck in
       * some mouse loop */
      kbused = 1;
    } else {
#endif
      /* try to see if there is any key to be processed */
      if( key_q_empty() ) {
	do {      
	  _GrMouseGetEvent((GR_M_MOTION | GR_M_KEYPRESS | GR_M_BUTTON_DOWN | GR_M_POLL)
			 , &mev, __LINE__);
	} while( !mev.flags );
	kbused = 0;
	/* set the help string */
	if( mev.flags & GR_M_MOTION ) {
	  if( gw->help_dwin == -1 ) continue; /* no help dwin set */
/* ERROR (previus "break" instead of "continue")
IT EXITS wi_interact AT MERE CURSOR MOTION */
	  if( gw->help_on ) {
	    char * help_string;
	    help_string = _locate_help( gw, mev.x, mev.y );
	    if( previous_help != help_string ) {
	      wi_clear_dwin( gw->help_dwin, PLANE_DWIN );
	      previous_help = help_string;
	      if( help_string != NULL )
		gtext( gw, gw->help_dwin, 3, 3, help_string);
	    }
	  }
	}
	if( mev.flags & GR_M_KEYPRESS ) {
	  key_q_push(key_to_sym(mev.key, mev.kbstat));
	}
      }
      
      /* decide which is the next selected grel, try the keys first */
      if( !key_q_empty() ) {
	long key;
	
	key = key_q_pop();
	kbused = 1;
	if( is_change_focus_key( key ) == NO_FDI  ) {
	  get_key_selection(&sel, gw, key);
	  if( ( sel.hitgrel != NULL )
	     && _is_selectable_grel( sel.hitgrel )  ) {
	    /* unmark any current selection on screen */
	    if( current_sel.hitgrel != NULL ) {
	      cursor_hide();
	      paintgrel( gw, current_sel.lasthitdwin, current_sel.hitgrel );
	      cursor_show();
	    }
	    memcpy( &current_sel, &sel, sizeof(sel) );
	  }
	}
	
	/* look for special keys */
	if( is_change_focus_key(key) != NO_FDI ) {
	   /* puts( "changing focus by key\n" ); */
	  /* unmark any current selection on screen */
	  if( current_sel.hitgrel != NULL ) {
	    cursor_hide();
	    paintgrel( gw, current_sel.lasthitdwin, current_sel.hitgrel );
	    cursor_show();
	  }
	  _locate_selection( gw, &current_sel, &current_sel
			    , is_change_focus_key(key) );
	  printf( "  selected grel: %x\n", current_sel.hitgrel );
#ifdef GWINTERACT_RETURNS_WHEN_CHANGING_FOCUS
	  if( current_sel.hitgrel != NULL ) {
	    cursor_hide();
	    paintgrel_current( gw, current_sel.lasthitdwin
			      , current_sel.hitgrel );
	    cursor_show();
	    return key;
	  }
#endif /* GWINTERACT_RETURNS_WHEN_CHANGING_FOCUS */       
	}
	/* eventually activate the current selection */
	if( current_sel.hitgrel != NULL )
	  if( key == action_key ){  
	    memcpy( &sel, &current_sel, sizeof(sel) );
	  }
      } else {
	/* look for a mouse selection */
	if( mev.buttons != 0 ) {
	  get_position_selection(&sel, gw, mev.x, mev.y);
	  printf( "changing focus by mouse\n");
          fflush(stdout);
	  /* remember it as the current selection */
#if 0
	  if( sel.hitgrel != NULL ) {
	    /* unmark any current selection on screen */
	    if( current_sel.hitgrel != NULL ) {
	      cursor_hide();
	      paintgrel( gw, current_sel.lasthitdwin, current_sel.hitgrel );
	      cursor_show();
	    }
	    memcpy( &current_sel, &sel, sizeof(sel));
	  }
#endif
	  kbused = 0;
	}
      }
#ifdef SELECTED_TEXTPAD_IS_ACTIVE
    }
#endif

    g = sel.hitgrel;

    if(g==NULL && !kbused) /* Button pressed outside an input widget */
      {
        fflush(stdout);
	wait_m_button_up();
	for(d=gw->dwinfill-1; d>=0; d--) {
	  if(gw->dw[d]->spotshotkey &&
	     mev.x >= gw->dw[d]->x0 && mev.x < gw->dw[d]->x0+gw->dw[d]->xl &&
	     mev.y >= gw->dw[d]->y0 && mev.y < gw->dw[d]->y0+gw->dw[d]->yl)
	    {
	      xspotshot = mev.x - gw->dw[d]->x0;
	      yspotshot = mev.y - gw->dw[d]->y0;
	      return gw->dw[d]->spotshotkey;
	    }
	}
      }
    
    if(g==NULL)
      continue;
    
    key = g -> gkey;
    if (g != (struct _grel *) NULL) {
      switch(g  -> gtype) {
      case HBUTTONGREL: 
	printf( "hbutton grel with key %d.\n", key );
	return key;
      case BUTTONGREL:
	/* terminal interaction */
        printf("Button grel selected.\n");
        fflush(stdout);
	cursor_hide();
	paintgrel(gw, sel.lasthitdwin, toggle_key(g));
	if(!kbused)
	  wait_m_button_up();
	paintgrel(gw, sel.lasthitdwin, toggle_key(g));
	cursor_show();
        printf("Button grel repainted.\n");
        fflush(stdout);
	/* toggle_key(g); */
	return key;
	break;
      case SWITCHGREL:
	/* non terminal interaction */
	cursor_hide();
	paintgrel(gw, sel.lasthitdwin, toggle_key(g));
	cursor_show();
	return key;
	break;
      case ASWITCHGREL:
	{ITERATOR it;
	 struct _grel * temp;
	 init_bwd_grel_iterator(gw, sel.lasthitdwin_ndx, &it);
	 while (check_lower_bound_grel(&it)) {
	   temp = access_grel(&it);
	   if ((temp -> gtype == ASWITCHGREL)
	       && (temp -> gswv == g -> gswv)) {
	     temp -> swvval = key;
	     cursor_hide();
	     paintgrel(gw, sel.lasthitdwin, temp);
	     cursor_show();
	   }
	   iterator_backward(&it);
	 }
       }
	return key;
	break;
      case TEXTPADGREL:
	puts( "Entering textpadgrel.\n"); fflush( stdout );
	if( !kbused )
	  wait_m_button_up();
	_tp_select( g-> ext, g->x1 - g->x0 );
	cursor_hide();
	paintgrel( gw, sel.lasthitdwin, g);
	cursor_show();
	while( 1 ) {
	  /* process a key */
	  long key;
	  int key_focus;
	  do {
	    _GrMouseGetEvent( (GR_M_KEYPRESS | GR_M_POLL), &mev, __LINE__ );
	  } while ( (mev.flags & GR_M_KEYPRESS)==0 );
	  key = key_to_sym( mev.key, mev.kbstat );
	  /* process special keys */
	  key_focus = is_change_focus_key( key );
	  if( ( key == 10) || (key == 13) ) {
	    _tp_end_selection( g->ext );
	    cursor_hide();
	    paintgrel_current( gw, sel.lasthitdwin, g );
	    cursor_show();
	    /* key_q_push( XK_Tab ); */
	    return g -> gkey;
	  }
	  if( (key_focus == NEXT_FDI)
	     || (key_focus == PREV_FDI)
	     ) {
	    _tp_end_selection( g->ext );
	    cursor_hide();
	    paintgrel( gw, sel.lasthitdwin, g);
	    cursor_show();
	    key_q_push( key );
	    printf( "Ending textpad interaction because of key %d.\n"
		   , key );
	    return g -> gkey;
	  }
	  _tp_process_key( g->ext, key, g->x1-g->x0 );
	  cursor_hide();
	  paintgrel( gw, sel.lasthitdwin, g);
	  cursor_show();
	}
	break;
      default:
	break;
      } /* switch */
    }  /* if */
  }      /* while 1 */
}

/*--
  \end{code}

  \funparagraph{wi\_accept}  % The name of the function(s)
  \ImplementationNotes{
  % How implementation of the function is done: algorithm---if special,
  % implementation decisions, discarded implementation alternatives
  }
  \Portability{ % What is assumed about the operating environment
  }
  \Changes{ % that are anticipated, if special provision was made for them
  }

  \begin{code}
  --*/


void gwaccept(GWIN * gw) { /* [FUN] */ 
  /* copy the internal values of the switches in the user's variables */
  ITERATOR it;
  short d;
  struct _grel * temp;
  
  /* map over all the dwins of the gwin */
/*  printf("CALL gwaccept\n");*/
  for (d = 0; d < gw -> dwinfill; d ++) {
    init_bwd_grel_iterator(gw, d, &it);
    while (check_lower_bound_grel(&it)) {
      temp = access_grel(&it);
      switch (temp -> gtype) {
      case SWITCHGREL:
      case ASWITCHGREL:
	* (temp -> gswv) = temp -> swvval;
	break;
      case TEXTPADGREL:
	strcpy((char *)(temp->gswv), _tp_access_contents(temp->ext));
	break;
      default:
	break;
      }
      iterator_backward(&it);
    }
  }
}

wi_accept()

{
  GWIN *g;

  g = wi_crt_gwin_ptr();
  gwaccept(g);
}

int gwipeep() { /* [FUN] */ 
  return 1;  /* don't work yet */
}


/*--
  \end{code}

  % MOVE THIS COMMENT TO THE END OF THE FILE
  \endoffile

  --*/
