/*    WIPort RESources
 *
 *    Copyright (c) 1994--1998 Alexandru Dan Corlan
 * 
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU Library General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    In short, you can use and modify this program. You can
 *    distribute the program with or without your modifications if you want,
 *    but you must not require licence fees and must provide the
 *    full source code with the distribution. If you make an application program
 *    which just calls functions from this library you may distribute that
 *    application program without source code, but also as an linkable object file, 
 *    and must distribute also this library with source code.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU Library General Public License for more details.
 *
 *    You should have received a copy of the GNU Library General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*--

\FileTitle{ % format: <short title> --- <long title>
WIPRES --- WIPORT RESource management system
}
\CopyrightNotice{ % format: Copyright \copyright <year(s)> <who>
Copyright \copyright 1994 Alexandru Dan CORLAN
}
\FileAuthor{ % the full name of the author
Alexandru Dan CORLAN
}
\AuthorAffiliation{ % Intitution of the author when writing the file
Electrocardiognosis, 28 Argentina str., Bucharest, ROMANIA
}
\RevisionHistory{ % write freely the revision history here
}
\vskip 1in

% The name of the package is expected to already be prezent
\PackagePurpose{  % be short
Manage a set of named values, named resources, which are stored
on disk in one or more files during executions of the program.
}
\FunctionInterraction{
% The order in which functions are expected to be called
% The way to use the package in general
There exist groups of similar functions for various types of resources.
In this version, the supported types are strings, integers and floats.
Expected usage is as follows: the {\tt wipres} function is called to
initialize the package. Names are assigned then to resource values
either by using {\tt sresdef, iresdef, fresdef} --- for string, integer
and float --- or the {\tt resread} function to read the associations
from a file. Given names, the values can be obtained with the
{\tt ires, fres and sres} functions respectively.  Values can be
modified with {\tt sresset, fresset, iresset}.
The whole set of resources
can be written to a file with {\tt reswrite}.

\AdvancedUsage1{
Certain groups of resources may be specific to a region of the dynamic
structure of a program. Programmer may choose to identify them by means
of a common prefix. For this goal the {\tt setresprefix} function is used
to declare such a prefix. After calling it, all other functions involving
names of resources take the prefix prepended to the argument of the resource.
Use {\tt setresprefix} with a {\tt NULL} string or a void string to
cease using any prefix.
}
}
\Exceptions{
Procedure-like functions return 0 if something goes wrong (for
example a name is not found). Resource valure returning functions
retur some potentially valid result (0, 0.0) with the exception 
of {\tt sres} which returns NULL if name not found.
Errors like name of the resource not found are considered to be programming
errors---they should never bother the user. Same is true about
resource-file not found, for which case the application should
define default values in the resources themselves.

The size of the resource name, including prefix, is expected never to
be longer than 64 characters --- because of many implementation
limits.
}
\GlobalEffects{
% Global effects on exported or external variables
None.
}
\Preconditions{
% Conditions to be met when the package starts to be used
None.
}
\Performance{
% How it is, not why and what to do
Locating a resource by name is done in an iterative way, which is very
inefficient when the number of resources grows large.
Resources should not be consulted frequently. When their values are
frequently used it is expected that the user program stores them in local
variables.
}

--*/


#define MAXRES 1024

void wipres();

/*--

% The name of the function is expected to already be prezent
\PurposeReturn{  % be short
Associates given name, type and value to a resource.
Return 1 if resource sucessfull, 0 otherwise. If the
resources already exited, the old one is replaced by the new one.

The string arguments are all copied into newly allocated memory
regions.
}
\Exceptions{
Should raise the following WIPRES exceptions: RES\_SPACE\_FULL if
there is no space left for a new exception; RES\_NAME\_TOO\_LONG if
the name of the resource is larger than the implementation limit
(64 characters); MEMORY\_FULL if newly allocated memory could not
be produced.
}
\GlobalEffects{
% Global effects on exported or external variables
None.
}
\Preconditions{
% Conditions to be met when the function is called
The {\tt wipres} must have been called.
}
--*/


short sresdef(char *name, char *str, char *cmt);
short iresdef(char *name, long argint, char *cmt);
short fresdef(char *name, float argflo, char *cmt);


/*--

\PurposeReturn{  % be short
}
\Exceptions{
}
\GlobalEffects{
% Global effects on exported or external variables
}
\Preconditions{
% Conditions to be met when the function is called
}
\Performance{
% How it is, not why and what to do about it
}

--*/

char *sres(char *name);
long ires(char *name);
float fres(char *name);

/*--

\PurposeReturn{  % be short
}
\Exceptions{
}
\GlobalEffects{
% Global effects on exported or external variables
}
\Preconditions{
% Conditions to be met when the function is called
}
\Performance{
% How it is, not why and what to do about it
}

--*/

short sresset(char *name, char *str);
short iresset(char *name, long iv);
short fresset(char *name, float fv);

/*--
\PurposeReturn{  % be short
}
\Exceptions{
}
\GlobalEffects{
% Global effects on exported or external variables
Both functions set the prefix to {\tt ""} and leave it so.
}
\Preconditions{
% Conditions to be met when the function is called
}
\Performance{
% How it is, not why and what to do about it
}
--*/

short reswrite(char *fnw);
short resread(char *fnr);

/*--
\PurposeReturn{  % be short
}
\Exceptions{
}
\GlobalEffects{
% Global effects on exported or external variables
}
\Preconditions{
% Conditions to be met when the function is called
}
\Performance{
% How it is, not why and what to do about it
}
--*/

short setresprefix(char *pf);
