/*    WIPTIME -- input of time objects in wiport
 *
 *    Copyright (c) 1994--1998 Alexandru Dan Corlan
 * 
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU Library General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    In short, you can use and modify this program. You can
 *    distribute the program with or without your modifications if you want,
 *    but you must not require licence fees and must provide the
 *    full source code with the distribution. If you make an application program
 *    which just calls functions from this library you may distribute that
 *    application program without source code, but also as an linkable object file, 
 *    and must distribute also this library with source code.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU Library General Public License for more details.
 *
 *    You should have received a copy of the GNU Library General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

/*--

  \RevisionHistory{ % write freely the revision history here
  $Log: wiptime.h,v $
 * Revision 1.2  1996/02/25  22:38:05  dcorlan
 * The wiport2l system, which now compiles from the box for MSDOS (I presume)
 * but anyway with svgalib-1.2.8  and grx-2.0, and with X11R6. Nevertheless,
 * this is the version shipped by mseritan and it does not work well.
 * Something is fishy with the keycodes and the mouse enters a dubious mode,
 * and it works veery slow and the current widget flickers on the screen.
 * It sometimes crashes when pressing a common button.
 *
 * wiport2x.c is actually obsolete.
 *
 * What I fear is that the files in the CVS repository are not the files
 * we actually use in the compilation.
 *
 * New things:
 *   wiport.fnt, wiport.fna are the new fonts.
 *   I don't know what should be the difference, if any, between Makefile
 *   and makefile.
 *
 * Revision 1.1  1995/01/15  19:42:23  root
 * Initial revision
 *
  }
  \vskip 1in

  \section{Wiport Time Package}
  % The name of the package is expected to be prezent,
  % normally in the proper ``section'' specification above.

  \PackagePurpose{  % be short
  }
  \FunctionInterraction{
  The \functiontag{wi\_time\_panel} function
  creates an internal representation
  and displays the textpad and the buttons which will achieve
  the input of a time moment. A pointer to a string is
  passed as the value of the time object to edit.
  This function may be called
  any number of times, to define more than one time ``panel''
  on the screen. Time panels are identified by a wi_keycode
  which is the same one which identifies the textpad
  in the panel.

  The application programmer should
  later call \functiontag{gwinteract} in order to wait
  for to user to press a button on the screen. The returned
  \typetag{wi_keycode} will be passed to 
  \functiontag{wi\_time\_input}. This function
  will look into all the time widgets that might have
  received the \typetag{wi_keycode}, and will eventually do the corresponding
  modification, notifying then the caller that the \typetag{wi_keycode} was
  processed.

  The fact that a given ``time panel'' was successfully changed
  can be verified with \functiontag{wi\_time\_changed\_p}. The
  new value can be restored in the argument string with a call
  to \functiontag{wi\_time\_accept}.

  There are 3 functions for deleting time panels. They are
  \functiontag{wi\_time\_del\_panel} which deletes a panel identified
  by its \typetag{wi_keycode}; \functiontag{wi\_time\_del\_dwin} which
  deletes all the time panels from a given dwin and
  \functiontag{wi\_time\_del\_all} which deletes all the time panels
  in the system.
  }
  \Exceptions{
  }
  \GlobalEffects{
  % Global effects on exported or external variables
  }
  \Preconditions{
  % Conditions to be met when the package starts to be used
  }
  \Performance{
  % How it is, not why and what to do
  }

  \dataparagraph{Time element names}

  \Definition{
  Symbols to be used when specifying what components of a time item are
  to be used in an editing or another type of operation. The values
  below are considered values of the type ``Time_Component''.
  }
  \SemanticStructure{
  }
  \ConsistencyRules{
  }

  \begin{code}
  --*/

#define YEAR4       1      /* year in 4 digits */
#define YEAR2       2      /* year in 2 digits */
#define TEXT_MONTH  3      /* month in 3 letters */
#define NUM_MONTH   4      /* monts in numbers, starting from 1 */
#define DAY         5      /* day of the month */
#define HOUR        6      /* hour of the day (24 hour) */
#define MINUTE      7      /* minute of the hour */
#define SECOND      8      /* second of the minute */


/*--
  \end{code}

  \funparagraph{wi\_time\_panel}
  % The name of the function is expected to be prezent
  % in the sectioning element above

  \PurposeReturn{
  Defines and displays the specified date and/or time and buttons
  for both mouse-only and keyboard editing. Only the components
  between \variabletag{from} and \variabletag{to} are actually displayed
  and modified.

  The function does not return anything.

  The {\tt asct} argument must point to a character string
  containing the date {\em and\/} time of day, with a
  format as supplied by \functiontag{asctime}~(3) or
  by \functiontag{ctime}~(3). 
  }
  \Exceptions{
  }
  \GlobalEffects{
  }
  \Preconditions{
  % Conditions to be met when the function is called
  }
  \Performance{
  % How it is, not why and what to do about it
  }

  \begin{code}
  --*/

short wi_time_panel(dwin d,               /* dwin in the current gwin */
		     pixed x0, pixed y0,   /* dwin position */
		     char *asct,           /* ASCII description of time */
		     short from, short to, /* Time_Components */
		     wi_keycode tkey,         /* wi_keycode of the time item */
		     wi_keycode inc0,         /* first increment wi_keycode */
		     wi_keycode dec0          /* first decrement wi_keycode */
		     );



/*--
  \end{code}

  \funparagraph{wi\_set\_time}
  % The name of the function is expected to be prezent
  % in the sectioning element above

  \PurposeReturn{
  Sets the time contents of a given time panel to the value contained
  in the argument string.
  }
  \Exceptions{
  }
  \GlobalEffects{
  % Global effects on exported or external variables
  }
  \Preconditions{
  % Conditions to be met when the function is called
  }
  \Performance{
  % How it is, not why and what to do about it
  }

  \begin{code}
  --*/


/*--
  \end{code}

  \funparagraph{wi\_time\_del\_panel, wi\_time\_del\_dwin,
  wi\_time\_del\_all}
  \PurposeReturn{
  These functions delete time pannels by \typetag{wi_keycode},
  \typetag{dwin} or all of them.
  }
  \Exceptions{
  }
  \GlobalEffects{
  % Global effects on exported or external variables
  }
  \Preconditions{
  % Conditions to be met when the function is called
  }
  \Performance{
  % How it is, not why and what to do about it
  }

  \begin{code}
  --*/

void wi_time_del_panel(wi_keycode k);
void wi_time_del_dwin(dwin d);
void wi_time_del_all();


/*--
  \end{code}

  \funparagraph{wi\_time\_input}
  \PurposeReturn{
  Processes the argument \typetag{wi_keycode} if it relates to any
  existing time panel. Performs all the changes in the internally
  stored time value. Returns 1 if a change was done, and 0
  if none was.
  }
  \Exceptions{
  }
  \GlobalEffects{
  % Global effects on exported or external variables
  }
  \Preconditions{
  % Conditions to be met when the function is called
  }
  \Performance{
  % How it is, not why and what to do about it
  }

  \begin{code}
  --*/

short wi_time_input(wi_keycode k);


/*--
\end{code}

\funparagraph{wi\_time\_val}
% The name of the function is expected to be prezent
% in the sectioning element above

\PurposeReturn{
Returns the current value of the argument time panel widget,
as a string that can be copied by the user.
}
\Exceptions{
}
\GlobalEffects{
% Global effects on exported or external variables
}
\Preconditions{
% Conditions to be met when the function is called
}
\Performance{
% How it is, not why and what to do about it
}

\begin{code}
--*/

char *wi_time_val(wi_keycode k);

/*--
  \end{code}

  % MOVE THIS COMMENT TO THE END OF THE FILE
  \endoffile

  --*/

