/*    WIPTOKEN
 *
 *    Copyright (c) 1994--1998 Marius Seritan
 * 
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU Library General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    In short, you can use and modify this program. You can
 *    distribute the program with or without your modifications if you want,
 *    but you must not require licence fees and must provide the
 *    full source code with the distribution. If you make an application program
 *    which just calls functions from this library you may distribute that
 *    application program without source code, but also as an linkable object file, 
 *    and must distribute also this library with source code.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU Library General Public License for more details.
 *
 *    You should have received a copy of the GNU Library General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: wiptoken.c,v $
 * Revision 1.1.1.2  1996/01/17  21:51:18  mseritan
 * This is the first release by M. Seritan, with the
 * old calls removed and the help, partial internationalisation
 * and full textpads (textbuffers included) implementated.
 *
 * Revision 1.1.1.1  1995/12/25  18:33:46  dcorlan
 * This is wiport, as it remained before Marius Seritan began finishing
 * the implementation. As a new designs decision, all the wiport related
 * source files are to be kept in a single source directory.
 *
 *
 */

#include <stdlib.h>

#include "wiptoken.h"


int wip_token_type( wip_token * tok ) {
  return tok->type;
}

/* return a character representation for the given token */
void wip_token_to_string(wip_token * tok, char ** string, int * len ) {
  switch( tok->type ) {
  case TOKEN_TEXT:
    *string = tok->data.text.contents;
    *len = tok->data.text.length;
    break;
  case TOKEN_MENU:
    *string = tok->data.menu.contents;
    *len = tok->data.menu.length;
    break;
  case TOKEN_LINK:
    *string = tok->data.link.contents;
    *len = tok->data.link.length;
    break;
  default:
    break;
  }
}

void wip_token_to_link(wip_token * tok, char ** string, int * len ) {
  switch( tok->type ) {
  case TOKEN_TEXT:
    *string = NULL;
    *len = 0;
    break;
  case TOKEN_MENU:
    *string = tok->data.menu.link_name;
    *len = tok->data.menu.link_len;
    break;
  case TOKEN_LINK:		/* not yet written in infoutil.c */
    *string = tok->data.link.link_name;
    *len = tok->data.link.link_len;
    break;
  default:
    break;
  }
}

int wip_token_text_set( wip_token * tok, int properties
		       , char * buffer, int len ) {
  tok->type=TOKEN_TEXT;
  tok->data.text.properties=TOKEN_TEXT_PLAIN;
  tok->data.text.contents=buffer;
  tok->data.text.length=len;
}

int wip_token_link_set( wip_token * tok
		       , char * buffer, int len
		       , char * link_name, int link_len
		       ) {
  tok->type=TOKEN_LINK;
  tok->data.link.contents=buffer;
  tok->data.link.length=len;
  tok->data.link.link_name=link_name;
  tok->data.link.link_len=link_len;
}

int wip_token_menuentry_set( wip_token * tok
		       , char * buffer, int len
		       , char * link_name, int link_len
		       ) {
  tok->type=TOKEN_MENU;
  tok->data.menu.contents=buffer;
  tok->data.menu.length=len;
  tok->data.menu.link_name=link_name;
  tok->data.menu.link_len=link_len;
}

int wip_token_par_set( wip_token * tok ) {
  tok->type=TOKEN_PAR;
}

int wip_token_eof_set( wip_token * tok ) {
  tok->type=TOKEN_EOF;
}

